/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.v1_20_5to1_20_3.rewriter;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntArrayTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viabackwards.api.rewriters.BackwardsStructuredItemRewriter;
import com.viaversion.viabackwards.api.rewriters.StructuredEnchantmentRewriter;
import com.viaversion.viabackwards.protocol.v1_20_5to1_20_3.Protocol1_20_5To1_20_3;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.Particle;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataContainer;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.StructuredItem;
import com.viaversion.viaversion.api.minecraft.item.data.FireworkExplosion;
import com.viaversion.viaversion.api.minecraft.item.data.Fireworks;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_20_2;
import com.viaversion.viaversion.api.type.types.version.Types1_20_3;
import com.viaversion.viaversion.api.type.types.version.Types1_20_5;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.packet.ServerboundPacket1_20_3;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.packet.ServerboundPackets1_20_3;
import com.viaversion.viaversion.protocols.v1_20_2to1_20_3.rewriter.RecipeRewriter1_20_3;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.Protocol1_20_3To1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.data.BannerPatterns1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ClientboundPacket1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.packet.ClientboundPackets1_20_5;
import com.viaversion.viaversion.protocols.v1_20_3to1_20_5.rewriter.StructuredDataConverter;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import com.viaversion.viaversion.util.Key;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlockItemPacketRewriter1_20_5
extends BackwardsStructuredItemRewriter<ClientboundPacket1_20_5, ServerboundPacket1_20_3, Protocol1_20_5To1_20_3> {
    private static final StructuredDataConverter DATA_CONVERTER = new StructuredDataConverter(true);
    private final Protocol1_20_3To1_20_5 vvProtocol = (Protocol1_20_3To1_20_5)Via.getManager().getProtocolManager().getProtocol(Protocol1_20_3To1_20_5.class);
    private final StructuredEnchantmentRewriter enchantmentRewriter = new StructuredEnchantmentRewriter(this);

    public BlockItemPacketRewriter1_20_5(Protocol1_20_5To1_20_3 protocol) {
        super(protocol, (Type<Item>)Types1_20_5.ITEM, (Type<Item[]>)Types1_20_5.ITEM_ARRAY, (Type<Item>)Types.ITEM1_20_2, (Type<Item[]>)Types.ITEM1_20_2_ARRAY);
        this.enchantmentRewriter.setRewriteIds(false);
    }

    public void registerPackets() {
        BlockRewriter blockRewriter = BlockRewriter.for1_20_2((Protocol)this.protocol);
        blockRewriter.registerBlockEvent((ClientboundPacketType)ClientboundPackets1_20_5.BLOCK_EVENT);
        blockRewriter.registerBlockUpdate((ClientboundPacketType)ClientboundPackets1_20_5.BLOCK_UPDATE);
        blockRewriter.registerSectionBlocksUpdate1_20((ClientboundPacketType)ClientboundPackets1_20_5.SECTION_BLOCKS_UPDATE);
        blockRewriter.registerLevelEvent((ClientboundPacketType)ClientboundPackets1_20_5.LEVEL_EVENT, 1010, 2001);
        blockRewriter.registerLevelChunk1_19((ClientboundPacketType)ClientboundPackets1_20_5.LEVEL_CHUNK_WITH_LIGHT, ChunkType1_20_2::new, (user, blockEntity) -> this.updateBlockEntityTag((UserConnection)user, blockEntity.tag()));
        ((Protocol1_20_5To1_20_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.BLOCK_ENTITY_DATA, wrapper -> {
            wrapper.passthrough(Types.BLOCK_POSITION1_14);
            wrapper.passthrough((Type)Types.VAR_INT);
            CompoundTag tag = (CompoundTag)wrapper.passthrough(Types.COMPOUND_TAG);
            this.updateBlockEntityTag(wrapper.user(), tag);
        });
        this.registerCooldown((ClientboundPacketType)ClientboundPackets1_20_5.COOLDOWN);
        this.registerSetContent1_17_1((ClientboundPacketType)ClientboundPackets1_20_5.CONTAINER_SET_CONTENT);
        this.registerSetSlot1_17_1((ClientboundPacketType)ClientboundPackets1_20_5.CONTAINER_SET_SLOT);
        this.registerAdvancements1_20_3((ClientboundPacketType)ClientboundPackets1_20_5.UPDATE_ADVANCEMENTS);
        this.registerContainerClick1_17_1((ServerboundPacketType)ServerboundPackets1_20_3.CONTAINER_CLICK);
        this.registerContainerSetData((ClientboundPacketType)ClientboundPackets1_20_5.CONTAINER_SET_DATA);
        this.registerSetCreativeModeSlot((ServerboundPacketType)ServerboundPackets1_20_3.SET_CREATIVE_MODE_SLOT);
        ((Protocol1_20_5To1_20_3)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_20_3.CONTAINER_BUTTON_CLICK, wrapper -> {
            int containerId = (Byte)wrapper.read((Type)Types.BYTE) & 0xFF;
            int buttonId = (Byte)wrapper.read((Type)Types.BYTE) & 0xFF;
            wrapper.write((Type)Types.VAR_INT, (Object)containerId);
            wrapper.write((Type)Types.VAR_INT, (Object)buttonId);
        });
        ((Protocol1_20_5To1_20_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.LEVEL_PARTICLES, wrapper -> {
            wrapper.write((Type)Types.VAR_INT, (Object)0);
            wrapper.passthrough((Type)Types.BOOLEAN);
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.FLOAT);
            wrapper.passthrough((Type)Types.FLOAT);
            wrapper.passthrough((Type)Types.FLOAT);
            float data = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            wrapper.passthrough((Type)Types.INT);
            Particle particle = (Particle)wrapper.read((Type)Types1_20_5.PARTICLE);
            ((Protocol1_20_5To1_20_3)this.protocol).getParticleRewriter().rewriteParticle(wrapper.user(), particle);
            if (particle.id() == ((Protocol1_20_5To1_20_3)this.protocol).getMappingData().getParticleMappings().mappedId("entity_effect")) {
                int color = (Integer)particle.removeArgument(0).getValue();
                if (data == 0.0f) {
                    wrapper.set((Type)Types.FLOAT, 3, (Object)Float.valueOf(color));
                }
            } else if (particle.id() == ((Protocol1_20_5To1_20_3)this.protocol).getMappingData().getParticleMappings().mappedId("dust_color_transition")) {
                particle.add(3, (Type)Types.FLOAT, (Object)((Float)particle.removeArgument(6).getValue()));
            }
            wrapper.set((Type)Types.VAR_INT, 0, (Object)particle.id());
            for (Particle.ParticleData argument : particle.getArguments()) {
                argument.write(wrapper);
            }
        });
        ((Protocol1_20_5To1_20_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.EXPLODE, wrapper -> {
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.FLOAT);
            int blocks = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            for (int i = 0; i < blocks; ++i) {
                wrapper.passthrough((Type)Types.BYTE);
                wrapper.passthrough((Type)Types.BYTE);
                wrapper.passthrough((Type)Types.BYTE);
            }
            wrapper.passthrough((Type)Types.FLOAT);
            wrapper.passthrough((Type)Types.FLOAT);
            wrapper.passthrough((Type)Types.FLOAT);
            wrapper.passthrough((Type)Types.VAR_INT);
            Particle smallExplosionParticle = (Particle)wrapper.passthroughAndMap((Type)Types1_20_5.PARTICLE, (Type)Types1_20_3.PARTICLE);
            Particle largeExplosionParticle = (Particle)wrapper.passthroughAndMap((Type)Types1_20_5.PARTICLE, (Type)Types1_20_3.PARTICLE);
            ((Protocol1_20_5To1_20_3)this.protocol).getParticleRewriter().rewriteParticle(wrapper.user(), smallExplosionParticle);
            ((Protocol1_20_5To1_20_3)this.protocol).getParticleRewriter().rewriteParticle(wrapper.user(), largeExplosionParticle);
            Holder soundEventHolder = (Holder)wrapper.read((Type)Types.SOUND_EVENT);
            if (soundEventHolder.isDirect()) {
                SoundEvent soundEvent = (SoundEvent)soundEventHolder.value();
                wrapper.write(Types.STRING, (Object)soundEvent.identifier());
                wrapper.write((Type)Types.OPTIONAL_FLOAT, (Object)soundEvent.fixedRange());
            } else {
                int soundId = ((Protocol1_20_5To1_20_3)this.protocol).getMappingData().getSoundMappings().getNewId(soundEventHolder.id());
                String soundKey = Protocol1_20_3To1_20_5.MAPPINGS.soundName(soundId);
                wrapper.write(Types.STRING, (Object)(soundKey != null ? soundKey : "minecraft:entity.generic.explode"));
                wrapper.write((Type)Types.OPTIONAL_FLOAT, null);
            }
        });
        ((Protocol1_20_5To1_20_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.MERCHANT_OFFERS, wrapper -> {
            wrapper.passthrough((Type)Types.VAR_INT);
            int size = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                Item input = this.handleItemToClient(wrapper.user(), (Item)wrapper.read(Types1_20_5.ITEM_COST));
                this.cleanInput(input);
                wrapper.write(Types.ITEM1_20_2, (Object)input);
                Item result = this.handleItemToClient(wrapper.user(), (Item)wrapper.read(Types1_20_5.ITEM));
                wrapper.write(Types.ITEM1_20_2, (Object)result);
                Item secondInput = (Item)wrapper.read(Types1_20_5.OPTIONAL_ITEM_COST);
                if (secondInput != null) {
                    secondInput = this.handleItemToClient(wrapper.user(), secondInput);
                    this.cleanInput(secondInput);
                }
                wrapper.write(Types.ITEM1_20_2, (Object)secondInput);
                wrapper.passthrough((Type)Types.BOOLEAN);
                wrapper.passthrough((Type)Types.INT);
                wrapper.passthrough((Type)Types.INT);
                wrapper.passthrough((Type)Types.INT);
                wrapper.passthrough((Type)Types.INT);
                wrapper.passthrough((Type)Types.FLOAT);
                wrapper.passthrough((Type)Types.INT);
            }
        });
        ((Protocol1_20_5To1_20_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.MAP_ITEM_DATA, wrapper -> {
            wrapper.passthrough((Type)Types.VAR_INT);
            wrapper.passthrough((Type)Types.BYTE);
            wrapper.passthrough((Type)Types.BOOLEAN);
            if (((Boolean)wrapper.passthrough((Type)Types.BOOLEAN)).booleanValue()) {
                int icons = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
                for (int i = 0; i < icons; ++i) {
                    int decorationType = (Integer)wrapper.read((Type)Types.VAR_INT);
                    wrapper.write((Type)Types.VAR_INT, (Object)(decorationType == 34 ? 32 : decorationType));
                    wrapper.passthrough((Type)Types.BYTE);
                    wrapper.passthrough((Type)Types.BYTE);
                    wrapper.passthrough((Type)Types.BYTE);
                    wrapper.passthrough(Types.OPTIONAL_TAG);
                }
            }
        });
        RecipeRewriter1_20_3 recipeRewriter = new RecipeRewriter1_20_3(this.protocol);
        ((Protocol1_20_5To1_20_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_20_5.UPDATE_RECIPES, wrapper -> {
            int size = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                String recipeIdentifier = (String)wrapper.read(Types.STRING);
                int serializerTypeId = (Integer)wrapper.read((Type)Types.VAR_INT);
                String serializerType = ((Protocol1_20_5To1_20_3)this.protocol).getMappingData().getRecipeSerializerMappings().mappedIdentifier(serializerTypeId);
                wrapper.write(Types.STRING, (Object)serializerType);
                wrapper.write(Types.STRING, (Object)recipeIdentifier);
                recipeRewriter.handleRecipeType(wrapper, Key.stripMinecraftNamespace((String)serializerType));
            }
        });
    }

    private void updateBlockEntityTag(UserConnection connection, CompoundTag tag) {
        if (tag == null) {
            return;
        }
        Tag profileTag = tag.remove("profile");
        if (profileTag instanceof StringTag) {
            tag.put("SkullOwner", profileTag);
        } else if (profileTag instanceof CompoundTag) {
            this.updateProfileTag(tag, (CompoundTag)profileTag);
        }
        ListTag patternsTag = tag.getListTag("patterns", CompoundTag.class);
        if (patternsTag != null) {
            for (CompoundTag patternTag : patternsTag) {
                String pattern = patternTag.getString("pattern", "");
                String color = patternTag.getString("color");
                String compactIdentifier = BannerPatterns1_20_5.fullIdToCompact((String)Key.stripMinecraftNamespace((String)pattern));
                if (compactIdentifier == null || color == null) continue;
                patternTag.remove("pattern");
                patternTag.remove("color");
                patternTag.putString("Pattern", compactIdentifier);
                patternTag.putInt("Color", BlockItemPacketRewriter1_20_5.colorId(color));
            }
            tag.remove("patterns");
            tag.put("Patterns", (Tag)patternsTag);
        }
    }

    private void updateProfileTag(CompoundTag tag, CompoundTag profileTag) {
        ListTag propertiesListTag;
        IntArrayTag idTag;
        CompoundTag skullOwnerTag = new CompoundTag();
        tag.put("SkullOwner", (Tag)skullOwnerTag);
        String name = profileTag.getString("name");
        if (name != null) {
            skullOwnerTag.putString("Name", name);
        }
        if ((idTag = profileTag.getIntArrayTag("id")) != null) {
            skullOwnerTag.put("Id", (Tag)idTag);
        }
        if ((propertiesListTag = profileTag.getListTag("properties", CompoundTag.class)) == null) {
            return;
        }
        CompoundTag propertiesTag = new CompoundTag();
        for (CompoundTag propertyTag : propertiesListTag) {
            String property = propertyTag.getString("name", "");
            String value = propertyTag.getString("value", "");
            String signature = propertyTag.getString("signature");
            ListTag list = new ListTag(CompoundTag.class);
            CompoundTag updatedPropertyTag = new CompoundTag();
            updatedPropertyTag.putString("Value", value);
            if (signature != null) {
                updatedPropertyTag.putString("Signature", signature);
            }
            list.add((Tag)updatedPropertyTag);
            propertiesTag.put(property, (Tag)list);
        }
        skullOwnerTag.put("Properties", (Tag)propertiesTag);
    }

    private void cleanInput(@Nullable Item item) {
        if (item == null || item.tag() == null) {
            return;
        }
        CompoundTag tag = item.tag();
        StructuredDataConverter.removeBackupTag((CompoundTag)tag);
        CompoundTag display = tag.getCompoundTag("display");
        if (display != null) {
            this.removeEmptyList(display, "Lore");
            if (display.isEmpty()) {
                tag.remove("display");
            }
        }
        this.removeEmptyList(tag, "Enchantments");
        this.removeEmptyList(tag, "AttributeModifiers");
        if (tag.getInt("RepairCost", -1) == 0) {
            tag.remove("RepairCost");
        }
        if (tag.isEmpty()) {
            item.setTag(null);
        }
    }

    private void removeEmptyList(CompoundTag tag, String key) {
        ListTag list = tag.getListTag(key);
        if (list != null && list.isEmpty()) {
            tag.remove(key);
        }
    }

    private static int colorId(String color) {
        return switch (color) {
            case "orange" -> 1;
            case "magenta" -> 2;
            case "light_blue" -> 3;
            case "yellow" -> 4;
            case "lime" -> 5;
            case "pink" -> 6;
            case "gray" -> 7;
            case "light_gray" -> 8;
            case "cyan" -> 9;
            case "purple" -> 10;
            case "blue" -> 11;
            case "brown" -> 12;
            case "green" -> 13;
            case "red" -> 14;
            case "black" -> 15;
            default -> 0;
        };
    }

    @Override
    public @Nullable Item handleItemToClient(UserConnection connection, Item item) {
        if (item.isEmpty()) {
            return null;
        }
        StructuredDataContainer data = item.dataContainer();
        item.dataContainer().setIdLookup(this.protocol, true);
        this.enchantmentRewriter.handleToClient(item);
        super.handleItemToClient(connection, item);
        this.updateComponent(connection, item, StructuredDataKey.ITEM_NAME, "item_name");
        this.updateComponent(connection, item, StructuredDataKey.CUSTOM_NAME, "custom_name");
        Tag[] lore = (Tag[])data.get(StructuredDataKey.LORE);
        if (lore != null) {
            for (Tag tag : lore) {
                ((Protocol1_20_5To1_20_3)this.protocol).getComponentRewriter().processTag(connection, tag);
            }
        }
        if (item.identifier() == 1105 && !data.has(StructuredDataKey.FIREWORKS)) {
            data.set(StructuredDataKey.FIREWORKS, (Object)new Fireworks(1, new FireworkExplosion[0]));
        }
        CompoundTag customData = (CompoundTag)data.get(StructuredDataKey.CUSTOM_DATA);
        Item oldItem = this.vvProtocol.getItemRewriter().toOldItem(connection, item, DATA_CONVERTER);
        if (customData != null) {
            if (oldItem.tag() == null) {
                oldItem.setTag(new CompoundTag());
            }
            oldItem.tag().put(this.nbtTagName(), (Tag)customData.copy());
        } else if (oldItem.tag() != null && oldItem.tag().isEmpty()) {
            oldItem.setTag(null);
        }
        return oldItem;
    }

    protected void updateItemDataComponents(UserConnection connection, Item item, boolean clientbound) {
    }

    @Override
    public Item handleItemToServer(UserConnection connection, @Nullable Item item) {
        Tag tag;
        if (item == null) {
            return StructuredItem.empty();
        }
        Item structuredItem = this.vvProtocol.getItemRewriter().toStructuredItem(connection, item);
        if (item.tag() != null && (tag = item.tag().get(this.nbtTagName())) instanceof CompoundTag) {
            CompoundTag tag2 = (CompoundTag)tag;
            structuredItem.dataContainer().set(StructuredDataKey.CUSTOM_DATA, (Object)tag2);
        }
        structuredItem.dataContainer().setIdLookup(this.protocol, false);
        this.enchantmentRewriter.handleToServer(structuredItem);
        return super.handleItemToServer(connection, structuredItem);
    }
}

