/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.rewriter.IdRewriteFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StatisticsRewriter<C extends ClientboundPacketType> {
    private static final int CUSTOM_STATS_CATEGORY = 8;
    private final Protocol<C, ?, ?, ?> protocol;

    public StatisticsRewriter(Protocol<C, ?, ?, ?> protocol) {
        this.protocol = protocol;
    }

    public void register(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            int size;
            int newSize = size = wrapper.passthrough(Types.VAR_INT).intValue();
            for (int i = 0; i < size; ++i) {
                int categoryId = wrapper.read(Types.VAR_INT);
                int statisticId = wrapper.read(Types.VAR_INT);
                int value = wrapper.read(Types.VAR_INT);
                if (categoryId == 8 && this.protocol.getMappingData().getStatisticsMappings() != null) {
                    statisticId = this.protocol.getMappingData().getStatisticsMappings().getNewId(statisticId);
                    if (statisticId == -1) {
                        --newSize;
                        continue;
                    }
                } else {
                    IdRewriteFunction statisticsRewriter;
                    RegistryType type = this.getRegistryTypeForStatistic(categoryId);
                    if (type != null && (statisticsRewriter = this.getRewriter(type)) != null) {
                        statisticId = statisticsRewriter.rewrite(statisticId);
                    }
                }
                wrapper.write(Types.VAR_INT, categoryId);
                wrapper.write(Types.VAR_INT, statisticId);
                wrapper.write(Types.VAR_INT, value);
            }
            if (newSize != size) {
                wrapper.set(Types.VAR_INT, 0, newSize);
            }
        });
    }

    protected @Nullable IdRewriteFunction getRewriter(RegistryType type) {
        return switch (type) {
            case RegistryType.BLOCK -> {
                if (this.protocol.getMappingData().getBlockMappings() != null) {
                    yield id -> this.protocol.getMappingData().getNewBlockId(id);
                }
                yield null;
            }
            case RegistryType.ITEM -> {
                if (this.protocol.getMappingData().getItemMappings() != null) {
                    yield id -> this.protocol.getMappingData().getNewItemId(id);
                }
                yield null;
            }
            case RegistryType.ENTITY -> {
                if (this.protocol.getEntityRewriter() != null) {
                    yield id -> this.protocol.getEntityRewriter().newEntityId(id);
                }
                yield null;
            }
            default -> throw new IllegalArgumentException("Unknown registry type in statistics packet: " + String.valueOf((Object)type));
        };
    }

    public @Nullable RegistryType getRegistryTypeForStatistic(int statisticsId) {
        return switch (statisticsId) {
            case 0 -> RegistryType.BLOCK;
            case 1, 2, 3, 4, 5 -> RegistryType.ITEM;
            case 6, 7 -> RegistryType.ENTITY;
            default -> null;
        };
    }
}

