/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.FullMappings;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.data.Mappings;
import com.viaversion.viaversion.api.minecraft.item.HashedItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.rewriter.ComponentRewriter;
import com.viaversion.viaversion.api.rewriter.RewriterBase;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.util.Limit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ItemRewriter<C extends ClientboundPacketType, S extends ServerboundPacketType, T extends Protocol<C, ?, ?, S>>
extends RewriterBase<T>
implements com.viaversion.viaversion.api.rewriter.ItemRewriter<T> {
    private final Type<Item> itemType;
    private final Type<Item> mappedItemType;
    private final Type<Item[]> itemArrayType;
    private final Type<Item[]> mappedItemArrayType;
    private final Type<Item> itemCostType;
    private final Type<Item> mappedItemCostType;
    private final Type<Item> optionalItemCostType;
    private final Type<Item> mappedOptionalItemCostType;

    public ItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType, Type<Item> itemCostType, Type<Item> optionalItemCostType, Type<Item> mappedItemCostType, Type<Item> mappedOptionalItemCostType) {
        super(protocol);
        this.itemType = itemType;
        this.itemArrayType = itemArrayType;
        this.mappedItemType = mappedItemType;
        this.mappedItemArrayType = mappedItemArrayType;
        this.itemCostType = itemCostType;
        this.mappedItemCostType = mappedItemCostType;
        this.optionalItemCostType = optionalItemCostType;
        this.mappedOptionalItemCostType = mappedOptionalItemCostType;
    }

    public ItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType, Type<Item> mappedItemType, Type<Item[]> mappedItemArrayType) {
        this(protocol, itemType, itemArrayType, mappedItemType, mappedItemArrayType, null, null, null, null);
    }

    public ItemRewriter(T protocol, Type<Item> itemType, Type<Item[]> itemArrayType) {
        this(protocol, itemType, itemArrayType, itemType, itemArrayType);
    }

    @Override
    public @Nullable Item handleItemToClient(UserConnection connection, @Nullable Item item) {
        if (item == null) {
            return null;
        }
        if (this.protocol.getMappingData() != null && this.protocol.getMappingData().getItemMappings() != null) {
            item.setIdentifier(this.protocol.getMappingData().getNewItemId(item.identifier()));
        }
        return item;
    }

    @Override
    public @Nullable Item handleItemToServer(UserConnection connection, @Nullable Item item) {
        if (item == null) {
            return null;
        }
        if (this.protocol.getMappingData() != null && this.protocol.getMappingData().getItemMappings() != null) {
            item.setIdentifier(this.protocol.getMappingData().getOldItemId(item.identifier()));
        }
        return item;
    }

    public void registerSetContent(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.UNSIGNED_BYTE);
            Item[] items = wrapper.passthroughAndMap(this.itemArrayType, this.mappedItemArrayType);
            for (int i = 0; i < items.length; ++i) {
                items[i] = this.handleItemToClient(wrapper.user(), items[i]);
            }
        });
    }

    public void registerSetContent1_17_1(C packetType) {
        this.registerSetContent1_17_1(packetType, Types.UNSIGNED_BYTE);
    }

    public void registerSetContent1_21_2(C packetType) {
        this.registerSetContent1_17_1(packetType, Types.VAR_INT);
    }

    private void registerSetContent1_17_1(C packetType, Type<? extends Number> containerIdType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(containerIdType);
            wrapper.passthrough(Types.VAR_INT);
            Item[] items = wrapper.passthroughAndMap(this.itemArrayType, this.mappedItemArrayType);
            for (int i = 0; i < items.length; ++i) {
                items[i] = this.handleItemToClient(wrapper.user(), items[i]);
            }
            this.passthroughClientboundItem(wrapper);
        });
    }

    public void registerOpenScreen(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            this.handleMenuType(wrapper);
        });
    }

    public void handleMenuType(PacketWrapper wrapper) {
        int windowType = wrapper.read(Types.VAR_INT);
        int mappedId = this.protocol.getMappingData().getMenuMappings().getNewId(windowType);
        if (mappedId == -1) {
            wrapper.cancel();
            return;
        }
        wrapper.write(Types.VAR_INT, mappedId);
    }

    public void registerSetSlot(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.BYTE);
            wrapper.passthrough(Types.SHORT);
            this.passthroughClientboundItem(wrapper);
        });
    }

    public void registerSetSlot1_17_1(C packetType) {
        this.registerSetSlot1_17_1(packetType, Types.BYTE);
    }

    public void registerSetSlot1_21_2(C packetType) {
        this.registerSetSlot1_17_1(packetType, Types.VAR_INT);
    }

    private void registerSetSlot1_17_1(C packetType, Type<? extends Number> containerIdType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(containerIdType);
            wrapper.passthrough(Types.VAR_INT);
            wrapper.passthrough(Types.SHORT);
            this.passthroughClientboundItem(wrapper);
        });
    }

    public void registerSetEquippedItem(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            wrapper.passthrough(Types.VAR_INT);
            this.passthroughClientboundItem(wrapper);
        });
    }

    public void registerSetEquipment(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            byte slot;
            wrapper.passthrough(Types.VAR_INT);
            do {
                slot = wrapper.passthrough(Types.BYTE);
                this.passthroughClientboundItem(wrapper);
            } while (slot < 0);
        });
    }

    public void registerSetCreativeModeSlot(S packetType) {
        this.protocol.registerServerbound(packetType, wrapper -> {
            wrapper.passthrough(Types.SHORT);
            wrapper.write(this.itemType, this.handleItemToServer(wrapper.user(), wrapper.read(this.mappedItemType)));
        });
    }

    public void registerSetCreativeModeSlot1_21_5(S packetType, Type<Item> lengthPrefixedItemType, Type<Item> mappedLengthPrefixedItemType) {
        this.protocol.registerServerbound(packetType, wrapper -> {
            wrapper.passthrough(Types.SHORT);
            this.passthroughLengthPrefixedItem(wrapper, lengthPrefixedItemType, mappedLengthPrefixedItemType);
        });
    }

    public void registerContainerClick(S packetType) {
        this.protocol.registerServerbound(packetType, wrapper -> {
            wrapper.passthrough(Types.BYTE);
            wrapper.passthrough(Types.SHORT);
            wrapper.passthrough(Types.BYTE);
            wrapper.passthrough(Types.SHORT);
            wrapper.passthrough(Types.VAR_INT);
            wrapper.write(this.itemType, this.handleItemToServer(wrapper.user(), wrapper.read(this.mappedItemType)));
        });
    }

    public void registerContainerClick1_17_1(S packetType) {
        this.registerContainerClick1_17_1(packetType, Types.BYTE);
    }

    public void registerContainerClick1_21_2(S packetType) {
        this.registerContainerClick1_17_1(packetType, Types.VAR_INT);
    }

    public void registerContainerClick1_17_1(S packetType, Type<? extends Number> containerIdType) {
        this.protocol.registerServerbound(packetType, wrapper -> {
            wrapper.passthrough(containerIdType);
            wrapper.passthrough(Types.VAR_INT);
            wrapper.passthrough(Types.SHORT);
            wrapper.passthrough(Types.BYTE);
            wrapper.passthrough(Types.VAR_INT);
            int length = Limit.max(wrapper.passthrough(Types.VAR_INT), 128);
            for (int i = 0; i < length; ++i) {
                wrapper.passthrough(Types.SHORT);
                wrapper.write(this.itemType, this.handleItemToServer(wrapper.user(), wrapper.read(this.mappedItemType)));
            }
            wrapper.write(this.itemType, this.handleItemToServer(wrapper.user(), wrapper.read(this.mappedItemType)));
        });
    }

    public void registerContainerClick1_21_5(S packetType) {
        this.protocol.registerServerbound(packetType, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            wrapper.passthrough(Types.VAR_INT);
            wrapper.passthrough(Types.SHORT);
            wrapper.passthrough(Types.BYTE);
            wrapper.passthrough(Types.VAR_INT);
            this.passthroughHashedItem(wrapper);
            int affectedItems = Limit.max(wrapper.passthrough(Types.VAR_INT), 128);
            for (int i = 0; i < affectedItems; ++i) {
                wrapper.passthrough(Types.SHORT);
                this.passthroughHashedItem(wrapper);
            }
        });
    }

    public void registerSetPlayerInventory(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            this.passthroughClientboundItem(wrapper);
        });
    }

    public void registerCooldown(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            int itemId = wrapper.read(Types.VAR_INT);
            wrapper.write(Types.VAR_INT, this.protocol.getMappingData().getNewItemId(itemId));
        });
    }

    public void registerCooldown1_21_2(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            String itemIdentifier = wrapper.read(Types.STRING);
            if (itemIdentifier != null) {
                itemIdentifier = this.mappedIdentifier(this.protocol.getMappingData().getFullItemMappings(), itemIdentifier);
            }
            wrapper.write(Types.STRING, itemIdentifier);
        });
    }

    public void registerCustomPayloadTradeList(C packetType) {
        this.protocol.registerClientbound(packetType, new PacketHandlers(){

            @Override
            protected void register() {
                this.map(Types.STRING);
                this.handlerSoftFail(wrapper -> {
                    String channel = wrapper.get(Types.STRING, 0);
                    if (channel.equals("MC|TrList")) {
                        ItemRewriter.this.handleTradeList(wrapper);
                    }
                });
            }
        });
    }

    public void handleTradeList(PacketWrapper wrapper) {
        wrapper.passthrough(Types.INT);
        int size = wrapper.passthrough(Types.UNSIGNED_BYTE).shortValue();
        for (int i = 0; i < size; ++i) {
            this.passthroughClientboundItem(wrapper);
            this.passthroughClientboundItem(wrapper);
            if (wrapper.passthrough(Types.BOOLEAN).booleanValue()) {
                this.passthroughClientboundItem(wrapper);
            }
            wrapper.passthrough(Types.BOOLEAN);
            wrapper.passthrough(Types.INT);
            wrapper.passthrough(Types.INT);
        }
    }

    public void registerMerchantOffers(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            int size = wrapper.passthrough(Types.UNSIGNED_BYTE).shortValue();
            for (int i = 0; i < size; ++i) {
                this.passthroughClientboundItem(wrapper);
                this.passthroughClientboundItem(wrapper);
                if (wrapper.passthrough(Types.BOOLEAN).booleanValue()) {
                    this.passthroughClientboundItem(wrapper);
                }
                wrapper.passthrough(Types.BOOLEAN);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.FLOAT);
                wrapper.passthrough(Types.INT);
            }
        });
    }

    public void registerMerchantOffers1_19(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            int size = wrapper.passthrough(Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                this.passthroughClientboundItem(wrapper);
                this.passthroughClientboundItem(wrapper);
                this.passthroughClientboundItem(wrapper);
                wrapper.passthrough(Types.BOOLEAN);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.FLOAT);
                wrapper.passthrough(Types.INT);
            }
        });
    }

    public void registerMerchantOffers1_20_5(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.VAR_INT);
            int size = wrapper.passthrough(Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                Item input = wrapper.read(this.itemCostType);
                wrapper.write(this.mappedItemCostType, this.handleItemToClient(wrapper.user(), input));
                this.passthroughClientboundItem(wrapper);
                Item secondInput = wrapper.read(this.optionalItemCostType);
                if (secondInput != null) {
                    this.handleItemToClient(wrapper.user(), secondInput);
                }
                wrapper.write(this.mappedOptionalItemCostType, secondInput);
                wrapper.passthrough(Types.BOOLEAN);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.INT);
                wrapper.passthrough(Types.FLOAT);
                wrapper.passthrough(Types.INT);
            }
        });
    }

    public void registerAdvancements(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.BOOLEAN);
            int size = wrapper.passthrough(Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.OPTIONAL_STRING);
                if (wrapper.passthrough(Types.BOOLEAN).booleanValue()) {
                    JsonElement title = wrapper.passthrough(Types.COMPONENT);
                    JsonElement description = wrapper.passthrough(Types.COMPONENT);
                    ComponentRewriter componentRewriter = this.protocol.getComponentRewriter();
                    if (componentRewriter != null) {
                        componentRewriter.processText(wrapper.user(), title);
                        componentRewriter.processText(wrapper.user(), description);
                    }
                    this.passthroughClientboundItem(wrapper);
                    wrapper.passthrough(Types.VAR_INT);
                    int flags = wrapper.passthrough(Types.INT);
                    if ((flags & 1) != 0) {
                        wrapper.passthrough(Types.STRING);
                    }
                    wrapper.passthrough(Types.FLOAT);
                    wrapper.passthrough(Types.FLOAT);
                }
                wrapper.passthrough(Types.STRING_ARRAY);
                int arrayLength = wrapper.passthrough(Types.VAR_INT);
                for (int array = 0; array < arrayLength; ++array) {
                    wrapper.passthrough(Types.STRING_ARRAY);
                }
            }
        });
    }

    public void registerAdvancements1_20_3(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.BOOLEAN);
            int size = wrapper.passthrough(Types.VAR_INT);
            for (int i = 0; i < size; ++i) {
                wrapper.passthrough(Types.STRING);
                wrapper.passthrough(Types.OPTIONAL_STRING);
                if (wrapper.passthrough(Types.BOOLEAN).booleanValue()) {
                    Tag title = wrapper.passthrough(Types.TAG);
                    Tag description = wrapper.passthrough(Types.TAG);
                    ComponentRewriter componentRewriter = this.protocol.getComponentRewriter();
                    if (componentRewriter != null) {
                        componentRewriter.processTag(wrapper.user(), title);
                        componentRewriter.processTag(wrapper.user(), description);
                    }
                    this.passthroughClientboundItem(wrapper);
                    wrapper.passthrough(Types.VAR_INT);
                    int flags = wrapper.passthrough(Types.INT);
                    if ((flags & 1) != 0) {
                        wrapper.passthrough(Types.STRING);
                    }
                    wrapper.passthrough(Types.FLOAT);
                    wrapper.passthrough(Types.FLOAT);
                }
                int requirements = wrapper.passthrough(Types.VAR_INT);
                for (int array = 0; array < requirements; ++array) {
                    wrapper.passthrough(Types.STRING_ARRAY);
                }
                wrapper.passthrough(Types.BOOLEAN);
            }
        });
    }

    public void registerContainerSetData(C packetType) {
        this.protocol.registerClientbound(packetType, wrapper -> {
            wrapper.passthrough(Types.UNSIGNED_BYTE);
            Mappings mappings = this.protocol.getMappingData().getEnchantmentMappings();
            if (mappings == null) {
                return;
            }
            short property = wrapper.passthrough(Types.SHORT);
            if (property >= 4 && property <= 6) {
                short enchantmentId = (short)mappings.getNewId(wrapper.read(Types.SHORT).shortValue());
                wrapper.write(Types.SHORT, enchantmentId);
            }
        });
    }

    protected void passthroughClientboundItem(PacketWrapper wrapper) {
        Item item = this.handleItemToClient(wrapper.user(), wrapper.read(this.itemType));
        wrapper.write(this.mappedItemType, item);
    }

    protected void passthroughHashedItem(PacketWrapper wrapper) {
        FullMappings dataComponentMappings;
        HashedItem item = wrapper.passthrough(Types.HASHED_ITEM);
        MappingData mappingData = this.protocol.getMappingData();
        if (mappingData == null) {
            return;
        }
        if (mappingData.getItemMappings() != null) {
            item.setIdentifier(mappingData.getOldItemId(item.identifier()));
        }
        if ((dataComponentMappings = this.protocol.getMappingData().getDataComponentSerializerMappings()) != null) {
            this.updateHashedItemDataComponentIds(item, dataComponentMappings.inverse());
        }
    }

    protected void updateHashedItemDataComponentIds(HashedItem item, FullMappings mappings) {
        IntSet removedData;
        Int2IntMap addedData = item.dataHashesById();
        if (!addedData.isEmpty()) {
            for (int id : addedData.keySet().toIntArray()) {
                int mappedId = mappings.getNewId(id);
                if (mappedId == id) continue;
                int hash = addedData.remove(id);
                addedData.put(mappedId, hash);
            }
        }
        if (!(removedData = item.removedDataIds()).isEmpty()) {
            for (int id : removedData.toIntArray()) {
                int mappedId = mappings.getNewId(id);
                if (mappedId == id) continue;
                removedData.remove(id);
                removedData.add(mappedId);
            }
        }
    }

    protected void passthroughLengthPrefixedItem(PacketWrapper wrapper, Type<Item> lengthPrefixedItemType, Type<Item> mappedLengthPrefixedItemType) {
        Item item = this.handleItemToServer(wrapper.user(), wrapper.read(mappedLengthPrefixedItemType));
        wrapper.write(lengthPrefixedItemType, item);
    }

    protected @Nullable String mappedIdentifier(FullMappings mappings, String identifier) {
        if (mappings.id(identifier) == -1) {
            return identifier;
        }
        return mappings.mappedIdentifier(identifier);
    }

    protected @Nullable String unmappedIdentifier(FullMappings mappings, String mappedIdentifier) {
        if (mappings.mappedId(mappedIdentifier) == -1) {
            return mappedIdentifier;
        }
        return mappings.identifier(mappedIdentifier);
    }

    @Override
    public Type<Item> itemType() {
        return this.itemType;
    }

    @Override
    public Type<Item[]> itemArrayType() {
        return this.itemArrayType;
    }

    @Override
    public Type<Item> mappedItemType() {
        return this.mappedItemType;
    }

    @Override
    public Type<Item[]> mappedItemArrayType() {
        return this.mappedItemArrayType;
    }
}

