/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.text.serializer.v1_21_4.json;

import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.libs.mcstructs.text.Style;
import com.viaversion.viaversion.libs.mcstructs.text.events.hover.AHoverEvent;
import com.viaversion.viaversion.libs.mcstructs.text.serializer.ITypedSerializer;
import com.viaversion.viaversion.libs.mcstructs.text.serializer.v1_20_3.json.JsonStyleSerializer_v1_20_3;
import com.viaversion.viaversion.libs.mcstructs.text.serializer.v1_20_5.json.JsonStyleSerializer_v1_20_5;
import java.util.List;
import java.util.function.Function;

public class JsonStyleSerializer_v1_21_4
extends JsonStyleSerializer_v1_20_5 {
    public JsonStyleSerializer_v1_21_4(Function<JsonStyleSerializer_v1_20_3, ITypedSerializer<JsonElement, AHoverEvent>> hoverEventSerializer) {
        super(hoverEventSerializer);
    }

    @Override
    public JsonElement serialize(Style object) {
        JsonObject out = super.serialize(object).getAsJsonObject();
        if (object.getShadowColor() != null) {
            out.addProperty("shadow_color", object.getShadowColor());
        }
        return out;
    }

    @Override
    public Style deserialize(JsonElement object) {
        Style style = super.deserialize(object);
        JsonObject obj = object.getAsJsonObject();
        if (obj.has("shadow_color")) {
            Integer shadowColor = this.optionalInt(obj, "shadow_color");
            if (shadowColor == null) {
                List<Number> numbers = this.asNumberStream(obj.get("shadow_color"));
                if (numbers.size() != 4) {
                    throw new IllegalArgumentException("Expected list with 4 values for 'shadow_color' tag");
                }
                int r = (int)Math.floor(numbers.get(0).floatValue() * 255.0f);
                int g = (int)Math.floor(numbers.get(1).floatValue() * 255.0f);
                int b = (int)Math.floor(numbers.get(2).floatValue() * 255.0f);
                int a = (int)Math.floor(numbers.get(3).floatValue() * 255.0f);
                shadowColor = a << 24 | r << 16 | g << 8 | b;
            }
            style.setShadowColor(shadowColor);
        }
        return style;
    }
}

