/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.viaversion.viaversion.libs.fastutil.ints.IntBidirectionalIterator;
import com.viaversion.viaversion.libs.fastutil.ints.IntLinkedOpenHashSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSortedSet;
import io.netty.buffer.ByteBuf;

public record TooltipDisplay(boolean hideTooltip, IntSortedSet hiddenComponents) {
    public static final Type<TooltipDisplay> TYPE = new Type<TooltipDisplay>(TooltipDisplay.class){

        @Override
        public TooltipDisplay read(ByteBuf buffer) {
            boolean hideTooltip = buffer.readBoolean();
            IntLinkedOpenHashSet hiddenComponents = new IntLinkedOpenHashSet();
            int size = Types.VAR_INT.readPrimitive(buffer);
            for (int i = 0; i < size; ++i) {
                hiddenComponents.add(Types.VAR_INT.readPrimitive(buffer));
            }
            return new TooltipDisplay(hideTooltip, hiddenComponents);
        }

        @Override
        public void write(ByteBuf buffer, TooltipDisplay value) {
            buffer.writeBoolean(value.hideTooltip());
            Types.VAR_INT.writePrimitive(buffer, value.hiddenComponents().size());
            IntBidirectionalIterator intBidirectionalIterator = value.hiddenComponents().iterator();
            while (intBidirectionalIterator.hasNext()) {
                int hiddenComponent = (Integer)intBidirectionalIterator.next();
                Types.VAR_INT.writePrimitive(buffer, hiddenComponent);
            }
        }
    };

    public TooltipDisplay rewrite(Int2IntFunction idRewriter) {
        if (this.hiddenComponents.isEmpty()) {
            return this;
        }
        IntLinkedOpenHashSet newHiddenComponents = new IntLinkedOpenHashSet();
        IntBidirectionalIterator intBidirectionalIterator = this.hiddenComponents.iterator();
        while (intBidirectionalIterator.hasNext()) {
            int hiddenComponent = (Integer)intBidirectionalIterator.next();
            newHiddenComponents.add(idRewriter.applyAsInt(hiddenComponent));
        }
        return new TooltipDisplay(this.hideTooltip, newHiddenComponents);
    }
}

