/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.minecraft.item.data.PotionEffect;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.ArrayType;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.viaversion.viaversion.util.Copyable;
import io.netty.buffer.ByteBuf;

public record Consumable1_21_2(float consumeSeconds, int animationType, Holder<SoundEvent> sound, boolean hasConsumeParticles, ConsumeEffect<?>[] consumeEffects) implements Copyable
{
    public static final Type<?>[] EFFECT_TYPES = new Type[]{ApplyStatusEffects.TYPE, Types.HOLDER_SET, Types.EMPTY, Types.FLOAT, Types.SOUND_EVENT};
    public static final Type<Consumable1_21_2> TYPE = new Type<Consumable1_21_2>(Consumable1_21_2.class){

        @Override
        public Consumable1_21_2 read(ByteBuf buffer) {
            float consumeSeconds = buffer.readFloat();
            int animationType = Types.VAR_INT.readPrimitive(buffer);
            Object sound = Types.SOUND_EVENT.read(buffer);
            boolean hasConsumeParticles = buffer.readBoolean();
            ConsumeEffect[] consumeEffects = (ConsumeEffect[])ConsumeEffect.ARRAY_TYPE.read(buffer);
            return new Consumable1_21_2(consumeSeconds, animationType, (Holder<SoundEvent>)sound, hasConsumeParticles, consumeEffects);
        }

        @Override
        public void write(ByteBuf buffer, Consumable1_21_2 value) {
            buffer.writeFloat(value.consumeSeconds);
            Types.VAR_INT.writePrimitive(buffer, value.animationType);
            Types.SOUND_EVENT.write(buffer, value.sound);
            buffer.writeBoolean(value.hasConsumeParticles);
            ConsumeEffect.ARRAY_TYPE.write(buffer, value.consumeEffects);
        }
    };

    public Consumable1_21_2 rewrite(Int2IntFunction soundIdRewriteFunction) {
        Holder<SoundEvent> soundHolder = this.sound.updateId(soundIdRewriteFunction);
        return soundHolder == this.sound ? this : new Consumable1_21_2(this.consumeSeconds, this.animationType, soundHolder, this.hasConsumeParticles, this.consumeEffects);
    }

    @Override
    public Consumable1_21_2 copy() {
        return new Consumable1_21_2(this.consumeSeconds, this.animationType, this.sound, this.hasConsumeParticles, this.copy(this.consumeEffects));
    }

    public record ConsumeEffect<T>(int id, Type<T> type, T value) {
        public static final Type<ConsumeEffect<?>> TYPE = new Type<ConsumeEffect<?>>(ConsumeEffect.class){

            @Override
            public ConsumeEffect<?> read(ByteBuf buffer) {
                int effectType = Types.VAR_INT.readPrimitive(buffer);
                Type<?> type = EFFECT_TYPES[effectType];
                Object value = type.read(buffer);
                return ConsumeEffect.of(effectType, type, value);
            }

            @Override
            public void write(ByteBuf buffer, ConsumeEffect<?> value) {
                Types.VAR_INT.writePrimitive(buffer, value.id);
                value.writeValue(buffer);
            }
        };
        public static final Type<ConsumeEffect<?>[]> ARRAY_TYPE = new ArrayType(TYPE);

        static <T> ConsumeEffect<T> of(int id, Type<T> type, Object value) {
            return new ConsumeEffect<Object>(id, type, value);
        }

        void writeValue(ByteBuf buf) {
            this.type.write(buf, this.value);
        }
    }

    public record ApplyStatusEffects(PotionEffect[] effects, float probability) {
        public static final Type<ApplyStatusEffects> TYPE = new Type<ApplyStatusEffects>(ApplyStatusEffects.class){

            @Override
            public ApplyStatusEffects read(ByteBuf buffer) {
                PotionEffect[] effects = (PotionEffect[])PotionEffect.ARRAY_TYPE.read(buffer);
                float probability = buffer.readFloat();
                return new ApplyStatusEffects(effects, probability);
            }

            @Override
            public void write(ByteBuf buffer, ApplyStatusEffects value) {
                PotionEffect.ARRAY_TYPE.write(buffer, value.effects);
                buffer.writeFloat(value.probability);
            }
        };
    }
}

