/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.minecraft.HolderSet;
import com.viaversion.viaversion.api.minecraft.data.StructuredData;
import com.viaversion.viaversion.api.minecraft.data.predicate.DataComponentMatchers;
import com.viaversion.viaversion.api.minecraft.item.data.StatePropertyMatcher;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.ArrayType;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import com.viaversion.viaversion.util.Copyable;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public record BlockPredicate(@Nullable HolderSet holderSet, StatePropertyMatcher @Nullable [] propertyMatchers, @Nullable CompoundTag tag, DataComponentMatchers dataMatchers) implements Copyable
{
    public static final Type<BlockPredicate> TYPE1_20_5 = new Type<BlockPredicate>(BlockPredicate.class){

        @Override
        public BlockPredicate read(ByteBuf buffer) {
            HolderSet holders = (HolderSet)Types.OPTIONAL_HOLDER_SET.read(buffer);
            StatePropertyMatcher[] propertyMatchers = buffer.readBoolean() ? (StatePropertyMatcher[])StatePropertyMatcher.ARRAY_TYPE.read(buffer) : null;
            CompoundTag tag = (CompoundTag)Types.OPTIONAL_COMPOUND_TAG.read(buffer);
            return new BlockPredicate(holders, propertyMatchers, tag, null);
        }

        @Override
        public void write(ByteBuf buffer, BlockPredicate value) {
            Types.OPTIONAL_HOLDER_SET.write(buffer, value.holderSet);
            buffer.writeBoolean(value.propertyMatchers != null);
            if (value.propertyMatchers != null) {
                StatePropertyMatcher.ARRAY_TYPE.write(buffer, value.propertyMatchers);
            }
            Types.OPTIONAL_COMPOUND_TAG.write(buffer, value.tag);
        }
    };
    public static final Type<BlockPredicate[]> ARRAY_TYPE1_20_5 = new ArrayType<BlockPredicate>(TYPE1_20_5);

    public BlockPredicate(@Nullable HolderSet holderSet, StatePropertyMatcher @Nullable [] propertyMatchers, @Nullable CompoundTag tag) {
        this(holderSet, propertyMatchers, tag, null);
    }

    public BlockPredicate rewrite(Int2IntFunction blockIdRewriter) {
        if (this.holderSet == null || this.holderSet.hasTagKey()) {
            return this;
        }
        HolderSet updatedHolders = this.holderSet.rewrite(blockIdRewriter);
        return new BlockPredicate(updatedHolders, this.propertyMatchers, this.tag);
    }

    @Override
    public BlockPredicate copy() {
        return new BlockPredicate(this.holderSet, this.copy(this.propertyMatchers), this.tag == null ? null : this.tag.copy());
    }

    public static final class BlockPredicateType1_21_5
    extends Type<BlockPredicate> {
        private final Type<DataComponentMatchers> matchersType;

        public BlockPredicateType1_21_5(Type<StructuredData<?>[]> dataArrayType) {
            super(BlockPredicate.class);
            this.matchersType = new DataComponentMatchers.DataComponentMatchersType(dataArrayType);
        }

        @Override
        public BlockPredicate read(ByteBuf buffer) {
            HolderSet holders = (HolderSet)Types.OPTIONAL_HOLDER_SET.read(buffer);
            StatePropertyMatcher[] propertyMatchers = buffer.readBoolean() ? (StatePropertyMatcher[])StatePropertyMatcher.ARRAY_TYPE.read(buffer) : null;
            CompoundTag tag = (CompoundTag)Types.OPTIONAL_COMPOUND_TAG.read(buffer);
            DataComponentMatchers matchers = (DataComponentMatchers)this.matchersType.read(buffer);
            return new BlockPredicate(holders, propertyMatchers, tag, matchers);
        }

        @Override
        public void write(ByteBuf buffer, BlockPredicate value) {
            Types.OPTIONAL_HOLDER_SET.write(buffer, value.holderSet);
            buffer.writeBoolean(value.propertyMatchers != null);
            if (value.propertyMatchers != null) {
                StatePropertyMatcher.ARRAY_TYPE.write(buffer, value.propertyMatchers);
            }
            Types.OPTIONAL_COMPOUND_TAG.write(buffer, value.tag);
            this.matchersType.write(buffer, value.dataMatchers);
        }
    }
}

