/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.ArrayType;
import com.viaversion.viaversion.util.Copyable;
import io.netty.buffer.ByteBuf;

public record Bee(CompoundTag entityData, int ticksInHive, int minTicksInHive) implements Copyable
{
    public static final Type<Bee> TYPE = new Type<Bee>(Bee.class){

        @Override
        public Bee read(ByteBuf buffer) {
            CompoundTag entityData = (CompoundTag)Types.COMPOUND_TAG.read(buffer);
            int ticksInHive = Types.VAR_INT.readPrimitive(buffer);
            int minTicksInHive = Types.VAR_INT.readPrimitive(buffer);
            return new Bee(entityData, ticksInHive, minTicksInHive);
        }

        @Override
        public void write(ByteBuf buffer, Bee value) {
            Types.COMPOUND_TAG.write(buffer, value.entityData);
            Types.VAR_INT.writePrimitive(buffer, value.ticksInHive);
            Types.VAR_INT.writePrimitive(buffer, value.minTicksInHive);
        }
    };
    public static final Type<Bee[]> ARRAY_TYPE = new ArrayType<Bee>(TYPE);

    @Override
    public Bee copy() {
        return new Bee(this.entityData.copy(), this.ticksInHive, this.minTicksInHive);
    }
}

