/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.exception;

import com.viaversion.viaversion.api.Via;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InformativeException
extends RuntimeException {
    private static final int MAX_MESSAGE_LENGTH = 5000;
    private final List<DataEntry> dataEntries = new ArrayList<DataEntry>();
    private boolean shouldBePrinted = true;
    private int sources;

    public InformativeException(Throwable cause) {
        super(cause);
    }

    public InformativeException set(String key, @Nullable Object value) {
        this.dataEntries.add(new DataEntry(key, value));
        return this;
    }

    public InformativeException addSource(Class<?> sourceClazz) {
        return this.set("Source " + this.sources++, this.getSource(sourceClazz));
    }

    private String getSource(Class<?> sourceClazz) {
        return sourceClazz.isAnonymousClass() ? sourceClazz.getName() + " (Anonymous)" : sourceClazz.getName();
    }

    public boolean shouldBePrinted() {
        return this.shouldBePrinted;
    }

    public void setShouldBePrinted(boolean shouldBePrinted) {
        this.shouldBePrinted = shouldBePrinted;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder("Please report this on the Via support Discord or open an issue on the relevant GitHub repository\n");
        boolean first = true;
        for (DataEntry entry : this.dataEntries) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(entry.name()).append(": ");
            Object s = String.valueOf(entry.value());
            if (!Via.getManager().isDebug() && ((String)s).length() > 10 && builder.length() + ((String)s).length() > 5000) {
                s = ((String)s).substring(0, 5000 - builder.length()) + "...";
            }
            builder.append(((String)s).replaceAll("\\s", ""));
        }
        return builder.toString();
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    private record DataEntry(String name, @Nullable Object value) {
    }
}

