/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.minecraft.EitherHolder;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.misc.EitherHolderType;
import com.viaversion.viaversion.api.type.types.misc.HolderType;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import io.netty.buffer.ByteBuf;

public record JukeboxPlayable(EitherHolder<JukeboxSong> song, boolean showInTooltip) {
    public static final Type<JukeboxPlayable> TYPE1_21 = new Type<JukeboxPlayable>(JukeboxPlayable.class){

        @Override
        public JukeboxPlayable read(ByteBuf buffer) {
            EitherHolder<JukeboxSong> position = EitherHolderType.read(buffer, JukeboxSong.TYPE);
            boolean showInTooltip = buffer.readBoolean();
            return new JukeboxPlayable(position, showInTooltip);
        }

        @Override
        public void write(ByteBuf buffer, JukeboxPlayable value) {
            EitherHolderType.write(buffer, value.song, JukeboxSong.TYPE);
            buffer.writeBoolean(value.showInTooltip);
        }
    };
    public static final Type<JukeboxPlayable> TYPE1_21_5 = new Type<JukeboxPlayable>(JukeboxPlayable.class){

        @Override
        public JukeboxPlayable read(ByteBuf buffer) {
            EitherHolder<JukeboxSong> position = EitherHolderType.read(buffer, JukeboxSong.TYPE);
            return new JukeboxPlayable(position, true);
        }

        @Override
        public void write(ByteBuf buffer, JukeboxPlayable value) {
            EitherHolderType.write(buffer, value.song, JukeboxSong.TYPE);
        }
    };

    public JukeboxPlayable(Holder<JukeboxSong> song, boolean showInTooltip) {
        this(EitherHolder.of(song), showInTooltip);
    }

    public JukeboxPlayable(String resourceKey, boolean showInTooltip) {
        this(EitherHolder.of(resourceKey), showInTooltip);
    }

    public JukeboxPlayable rewrite(Int2IntFunction soundIdRewriteFunction) {
        if (this.song.hasKey()) {
            return this;
        }
        Holder<JukeboxSong> songHolder = this.song.holder();
        if (songHolder.hasId()) {
            return this;
        }
        JukeboxSong rewrittenSong = songHolder.value().rewrite(soundIdRewriteFunction);
        return rewrittenSong == songHolder.value() ? this : new JukeboxPlayable(Holder.of(rewrittenSong), this.showInTooltip);
    }

    public record JukeboxSong(Holder<SoundEvent> soundEvent, Tag description, float lengthInSeconds, int comparatorOutput) {
        public static final HolderType<JukeboxSong> TYPE = new HolderType<JukeboxSong>(){

            @Override
            public JukeboxSong readDirect(ByteBuf buffer) {
                Object soundEvent = Types.SOUND_EVENT.read(buffer);
                Tag description = (Tag)Types.TAG.read(buffer);
                float lengthInSeconds = buffer.readFloat();
                int useDuration = Types.VAR_INT.readPrimitive(buffer);
                return new JukeboxSong((Holder<SoundEvent>)soundEvent, description, lengthInSeconds, useDuration);
            }

            @Override
            public void writeDirect(ByteBuf buffer, JukeboxSong value) {
                Types.SOUND_EVENT.write(buffer, value.soundEvent);
                Types.TAG.write(buffer, value.description);
                buffer.writeFloat(value.lengthInSeconds);
                Types.VAR_INT.writePrimitive(buffer, value.comparatorOutput);
            }
        };

        public JukeboxSong rewrite(Int2IntFunction soundIdRewriteFunction) {
            Holder<SoundEvent> soundEvent = this.soundEvent.updateId(soundIdRewriteFunction);
            return soundEvent == this.soundEvent ? this : new JukeboxSong(soundEvent, this.description, this.lengthInSeconds, this.comparatorOutput);
        }
    }
}

