/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.HolderSet;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public record Equippable(int equipmentSlot, Holder<SoundEvent> soundEvent, @Nullable String model, @Nullable String cameraOverlay, @Nullable HolderSet allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt, boolean equipOnInteract) {
    public static final Type<Equippable> TYPE1_21_2 = new Type<Equippable>(Equippable.class){

        @Override
        public Equippable read(ByteBuf buffer) {
            int equipmentSlot = Types.VAR_INT.readPrimitive(buffer);
            Object soundEvent = Types.SOUND_EVENT.read(buffer);
            String model = (String)Types.OPTIONAL_STRING.read(buffer);
            String cameraOverlay = (String)Types.OPTIONAL_STRING.read(buffer);
            HolderSet allowedEntities = (HolderSet)Types.OPTIONAL_HOLDER_SET.read(buffer);
            boolean dispensable = buffer.readBoolean();
            boolean swappable = buffer.readBoolean();
            boolean damageOnHurt = buffer.readBoolean();
            return new Equippable(equipmentSlot, (Holder<SoundEvent>)soundEvent, model, cameraOverlay, allowedEntities, dispensable, swappable, damageOnHurt);
        }

        @Override
        public void write(ByteBuf buffer, Equippable value) {
            Types.VAR_INT.writePrimitive(buffer, value.equipmentSlot());
            Types.SOUND_EVENT.write(buffer, value.soundEvent());
            Types.OPTIONAL_STRING.write(buffer, value.model());
            Types.OPTIONAL_STRING.write(buffer, value.cameraOverlay());
            Types.OPTIONAL_HOLDER_SET.write(buffer, value.allowedEntities());
            buffer.writeBoolean(value.dispensable());
            buffer.writeBoolean(value.swappable());
            buffer.writeBoolean(value.damageOnHurt());
        }
    };
    public static final Type<Equippable> TYPE1_21_5 = new Type<Equippable>(Equippable.class){

        @Override
        public Equippable read(ByteBuf buffer) {
            int equipmentSlot = Types.VAR_INT.readPrimitive(buffer);
            Object soundEvent = Types.SOUND_EVENT.read(buffer);
            String model = (String)Types.OPTIONAL_STRING.read(buffer);
            String cameraOverlay = (String)Types.OPTIONAL_STRING.read(buffer);
            HolderSet allowedEntities = (HolderSet)Types.OPTIONAL_HOLDER_SET.read(buffer);
            boolean dispensable = buffer.readBoolean();
            boolean swappable = buffer.readBoolean();
            boolean damageOnHurt = buffer.readBoolean();
            boolean equipOnInteract = buffer.readBoolean();
            return new Equippable(equipmentSlot, (Holder<SoundEvent>)soundEvent, model, cameraOverlay, allowedEntities, dispensable, swappable, damageOnHurt, equipOnInteract);
        }

        @Override
        public void write(ByteBuf buffer, Equippable value) {
            Types.VAR_INT.writePrimitive(buffer, value.equipmentSlot());
            Types.SOUND_EVENT.write(buffer, value.soundEvent());
            Types.OPTIONAL_STRING.write(buffer, value.model());
            Types.OPTIONAL_STRING.write(buffer, value.cameraOverlay());
            Types.OPTIONAL_HOLDER_SET.write(buffer, value.allowedEntities());
            buffer.writeBoolean(value.dispensable());
            buffer.writeBoolean(value.swappable());
            buffer.writeBoolean(value.damageOnHurt());
            buffer.writeBoolean(value.equipOnInteract());
        }
    };

    public Equippable(int equipmentSlot, Holder<SoundEvent> soundEvent, @Nullable String model, @Nullable String cameraOverlay, @Nullable HolderSet allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt) {
        this(equipmentSlot, soundEvent, model, cameraOverlay, allowedEntities, dispensable, swappable, damageOnHurt, true);
    }

    public Equippable rewrite(Int2IntFunction soundIdRewriter) {
        Holder<SoundEvent> soundEvent = this.soundEvent.updateId(soundIdRewriter);
        return soundEvent == this.soundEvent ? this : new Equippable(this.equipmentSlot, soundEvent, this.model, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt, this.equipOnInteract);
    }
}

