#!/bin/bash

SERVER_JAR='paper-1.20.4'
JAVA_MEMORY_ARGS=('-Xms2G' '-Xmx2G')
JAVA_PATH='../java/jdk-21.0.1+12-jre/bin/java'

cd "$(dirname "$0")" || exit

CURRENT_SERVER="$(basename "$(pwd)")"

$JAVA_PATH "${JAVA_MEMORY_ARGS[@]}" -Dmcserver=$CURRENT_SERVER -Dfile.encoding=UTF-8 -XX:+UseG1GC -XX:+ParallelRefProcEnabled -XX:MaxGCPauseMillis=200 -XX:+UnlockExperimentalVMOptions -XX:+DisableExplicitGC -XX:+AlwaysPreTouch -XX:G1NewSizePercent=30 -XX:G1MaxNewSizePercent=40 -XX:G1HeapRegionSize=8M -XX:G1ReservePercent=20 -XX:G1HeapWastePercent=5 -XX:G1MixedGCCountTarget=4 -XX:InitiatingHeapOccupancyPercent=15 -XX:G1MixedGCLiveThresholdPercent=90 -XX:G1RSetUpdatingPauseTimePercent=5 -XX:SurvivorRatio=32 -XX:+PerfDisableSharedMem -XX:MaxTenuringThreshold=1 -Dusing.aikars.flags=https://mcflags.emc.gs -Daikars.new.flags=true -jar $SERVER_JAR.jar nogui --world-container worlds
