/*
 * Decompiled with CFR 0.152.
 */
package paperclip.libs.io.sigpipe.jbsdiff;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Offset {
    public static final int OFFSET_SIZE = 8;

    Offset() {
    }

    public static int readOffset(InputStream in) throws IOException {
        byte[] buf = new byte[8];
        int bytesRead = in.read(buf);
        if (bytesRead < 8) {
            throw new IOException("Could not read offset.");
        }
        int y = 0;
        y = buf[7] & 0x7F;
        y *= 256;
        y += buf[6] & 0xFF;
        y *= 256;
        y += buf[5] & 0xFF;
        y *= 256;
        y += buf[4] & 0xFF;
        y *= 256;
        y += buf[3] & 0xFF;
        y *= 256;
        y += buf[2] & 0xFF;
        y *= 256;
        y += buf[1] & 0xFF;
        y *= 256;
        if ((y += buf[0] & 0xFF) < 0) {
            throw new IOException("Integer overflow: 64-bit offsets not supported.");
        }
        if ((buf[7] & 0x80) != 0) {
            y = -y;
        }
        return y;
    }

    public static void writeOffset(int value, OutputStream out) throws IOException {
        byte[] buf = new byte[8];
        int y = 0;
        if (value < 0) {
            y = -value;
            buf[7] = (byte)(buf[7] | 0x80);
        } else {
            y = value;
        }
        buf[0] = (byte)(buf[0] | y % 256);
        y -= buf[0] & 0xFF;
        buf[1] = (byte)(buf[1] | (y /= 256) % 256);
        y -= buf[1] & 0xFF;
        buf[2] = (byte)(buf[2] | (y /= 256) % 256);
        y -= buf[2] & 0xFF;
        buf[3] = (byte)(buf[3] | (y /= 256) % 256);
        y -= buf[3] & 0xFF;
        buf[4] = (byte)(buf[4] | (y /= 256) % 256);
        y -= buf[4] & 0xFF;
        buf[5] = (byte)(buf[5] | (y /= 256) % 256);
        y -= buf[5] & 0xFF;
        buf[6] = (byte)(buf[6] | (y /= 256) % 256);
        y -= buf[6] & 0xFF;
        buf[7] = (byte)(buf[7] | (y /= 256) % 256);
        out.write(buf);
    }
}

