/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_19_4to1_20.packets;

import com.viaversion.viabackwards.api.rewriters.ItemRewriter;
import com.viaversion.viabackwards.protocol.protocol1_19_4to1_20.Protocol1_19_4To1_20;
import com.viaversion.viabackwards.protocol.protocol1_19_4to1_20.storage.BackSignEditStorage;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_18;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ClientboundPackets1_19_4;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.ServerboundPackets1_19_4;
import com.viaversion.viaversion.protocols.protocol1_19_4to1_19_3.rewriter.RecipeRewriter1_19_4;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import com.viaversion.viaversion.util.Key;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BlockItemPackets1_20
extends ItemRewriter<ClientboundPackets1_19_4, ServerboundPackets1_19_4, Protocol1_19_4To1_20> {
    private static final Set<String> NEW_TRIM_PATTERNS = new HashSet<String>(Arrays.asList("host", "raiser", "shaper", "silence", "wayfinder"));

    public BlockItemPackets1_20(Protocol1_19_4To1_20 protocol) {
        super(protocol);
    }

    public void registerPackets() {
        final BlockRewriter blockRewriter = BlockRewriter.for1_14((Protocol)this.protocol);
        blockRewriter.registerBlockAction((ClientboundPacketType)ClientboundPackets1_19_4.BLOCK_ACTION);
        blockRewriter.registerBlockChange((ClientboundPacketType)ClientboundPackets1_19_4.BLOCK_CHANGE);
        blockRewriter.registerEffect((ClientboundPacketType)ClientboundPackets1_19_4.EFFECT, 1010, 2001);
        blockRewriter.registerBlockEntityData((ClientboundPacketType)ClientboundPackets1_19_4.BLOCK_ENTITY_DATA, this::handleBlockEntity);
        ((Protocol1_19_4To1_20)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_4.CHUNK_DATA, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.handler(blockRewriter.chunkDataHandler1_19(ChunkType1_18::new, x$0 -> BlockItemPackets1_20.this.handleBlockEntity(x$0)));
                this.create((Type)Type.BOOLEAN, true);
            }
        });
        ((Protocol1_19_4To1_20)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_4.UPDATE_LIGHT, wrapper -> {
            wrapper.passthrough((Type)Type.VAR_INT);
            wrapper.passthrough((Type)Type.VAR_INT);
            wrapper.write((Type)Type.BOOLEAN, (Object)true);
        });
        ((Protocol1_19_4To1_20)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_4.MULTI_BLOCK_CHANGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.LONG);
                this.create((Type)Type.BOOLEAN, false);
                this.handler(wrapper -> {
                    for (BlockChangeRecord record : (BlockChangeRecord[])wrapper.passthrough(Type.VAR_LONG_BLOCK_CHANGE_RECORD_ARRAY)) {
                        record.setBlockId(((Protocol1_19_4To1_20)BlockItemPackets1_20.this.protocol).getMappingData().getNewBlockStateId(record.getBlockId()));
                    }
                });
            }
        });
        this.registerOpenWindow((ClientboundPacketType)ClientboundPackets1_19_4.OPEN_WINDOW);
        this.registerSetCooldown((ClientboundPacketType)ClientboundPackets1_19_4.COOLDOWN);
        this.registerWindowItems1_17_1((ClientboundPacketType)ClientboundPackets1_19_4.WINDOW_ITEMS);
        this.registerSetSlot1_17_1((ClientboundPacketType)ClientboundPackets1_19_4.SET_SLOT);
        this.registerEntityEquipmentArray((ClientboundPacketType)ClientboundPackets1_19_4.ENTITY_EQUIPMENT);
        this.registerClickWindow1_17_1((ServerboundPacketType)ServerboundPackets1_19_4.CLICK_WINDOW);
        this.registerTradeList1_19((ClientboundPacketType)ClientboundPackets1_19_4.TRADE_LIST);
        this.registerCreativeInvAction((ServerboundPacketType)ServerboundPackets1_19_4.CREATIVE_INVENTORY_ACTION, Type.ITEM1_13_2);
        this.registerWindowPropertyEnchantmentHandler((ClientboundPacketType)ClientboundPackets1_19_4.WINDOW_PROPERTY);
        this.registerSpawnParticle1_19((ClientboundPacketType)ClientboundPackets1_19_4.SPAWN_PARTICLE);
        ((Protocol1_19_4To1_20)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_4.ADVANCEMENTS, wrapper -> {
            wrapper.passthrough((Type)Type.BOOLEAN);
            int size = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
            for (int i = 0; i < size; ++i) {
                wrapper.passthrough(Type.STRING);
                if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                    wrapper.passthrough(Type.STRING);
                }
                if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                    wrapper.passthrough(Type.COMPONENT);
                    wrapper.passthrough(Type.COMPONENT);
                    this.handleItemToClient((Item)wrapper.passthrough(Type.ITEM1_13_2));
                    wrapper.passthrough((Type)Type.VAR_INT);
                    int flags = (Integer)wrapper.passthrough((Type)Type.INT);
                    if ((flags & 1) != 0) {
                        wrapper.passthrough(Type.STRING);
                    }
                    wrapper.passthrough((Type)Type.FLOAT);
                    wrapper.passthrough((Type)Type.FLOAT);
                }
                wrapper.passthrough(Type.STRING_ARRAY);
                int arrayLength = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
                for (int array = 0; array < arrayLength; ++array) {
                    wrapper.passthrough(Type.STRING_ARRAY);
                }
                wrapper.read((Type)Type.BOOLEAN);
            }
        });
        ((Protocol1_19_4To1_20)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_4.OPEN_SIGN_EDITOR, wrapper -> {
            Position position = (Position)wrapper.passthrough(Type.POSITION1_14);
            boolean frontSide = (Boolean)wrapper.read((Type)Type.BOOLEAN);
            if (frontSide) {
                wrapper.user().remove(BackSignEditStorage.class);
            } else {
                wrapper.user().put((StorableObject)new BackSignEditStorage(position));
            }
        });
        ((Protocol1_19_4To1_20)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_19_4.UPDATE_SIGN, wrapper -> {
            Position position = (Position)wrapper.passthrough(Type.POSITION1_14);
            BackSignEditStorage backSignEditStorage = (BackSignEditStorage)wrapper.user().remove(BackSignEditStorage.class);
            boolean frontSide = backSignEditStorage == null || !backSignEditStorage.position().equals((Object)position);
            wrapper.write((Type)Type.BOOLEAN, (Object)frontSide);
        });
        new RecipeRewriter1_19_4(this.protocol).register((ClientboundPacketType)ClientboundPackets1_19_4.DECLARE_RECIPES);
    }

    @Override
    public @Nullable Item handleItemToClient(@Nullable Item item) {
        StringTag patternStringTag;
        String pattern;
        Tag patternTag;
        Tag trimTag;
        if (item == null) {
            return null;
        }
        super.handleItemToClient(item);
        if (item.tag() != null && (trimTag = item.tag().get("Trim")) instanceof CompoundTag && (patternTag = ((CompoundTag)trimTag).get("pattern")) instanceof StringTag && NEW_TRIM_PATTERNS.contains(pattern = Key.stripMinecraftNamespace((String)(patternStringTag = (StringTag)patternTag).getValue()))) {
            item.tag().remove("Trim");
            item.tag().put(this.nbtTagName + "|Trim", trimTag);
        }
        return item;
    }

    @Override
    public @Nullable Item handleItemToServer(@Nullable Item item) {
        Tag trimTag;
        if (item == null) {
            return null;
        }
        super.handleItemToServer(item);
        if (item.tag() != null && (trimTag = item.tag().remove(this.nbtTagName + "|Trim")) != null) {
            item.tag().put("Trim", trimTag);
        }
        return item;
    }

    private void handleBlockEntity(BlockEntity blockEntity) {
        if (blockEntity.typeId() != 7 && blockEntity.typeId() != 8) {
            return;
        }
        CompoundTag tag = blockEntity.tag();
        CompoundTag frontText = (CompoundTag)tag.remove("front_text");
        tag.remove("back_text");
        if (frontText != null) {
            Tag glowing;
            this.writeMessages(frontText, tag, false);
            this.writeMessages(frontText, tag, true);
            Tag color = frontText.remove("color");
            if (color != null) {
                tag.put("Color", color);
            }
            if ((glowing = frontText.remove("has_glowing_text")) != null) {
                tag.put("GlowingText", glowing);
            }
        }
    }

    private void writeMessages(CompoundTag frontText, CompoundTag tag, boolean filtered) {
        ListTag messages = (ListTag)frontText.get(filtered ? "filtered_messages" : "messages");
        if (messages == null) {
            return;
        }
        int i = 0;
        for (Tag message : messages) {
            tag.put((filtered ? "FilteredText" : "Text") + ++i, message);
        }
    }
}

