/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_15_2to1_16.packets;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.rewriters.EnchantmentRewriter;
import com.viaversion.viabackwards.api.rewriters.ItemRewriter;
import com.viaversion.viabackwards.api.rewriters.MapColorRewriter;
import com.viaversion.viabackwards.protocol.protocol1_15_2to1_16.Protocol1_15_2To1_16;
import com.viaversion.viabackwards.protocol.protocol1_15_2to1_16.data.MapColorRewrites;
import com.viaversion.viabackwards.protocol.protocol1_16_1to1_16_2.storage.BiomeStorage;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.UUIDIntArrayType;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_15;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_16;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntArrayTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.LongArrayTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.ServerboundPackets1_14;
import com.viaversion.viaversion.protocols.protocol1_15to1_14_4.ClientboundPackets1_15;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.ClientboundPackets1_16;
import com.viaversion.viaversion.protocols.protocol1_16to1_15_2.packets.InventoryPackets;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import com.viaversion.viaversion.rewriter.RecipeRewriter;
import com.viaversion.viaversion.util.CompactArrayUtil;
import com.viaversion.viaversion.util.Key;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

public class BlockItemPackets1_16
extends ItemRewriter<ClientboundPackets1_16, ServerboundPackets1_14, Protocol1_15_2To1_16> {
    private EnchantmentRewriter enchantmentRewriter;

    public BlockItemPackets1_16(Protocol1_15_2To1_16 protocol) {
        super(protocol);
    }

    protected void registerPackets() {
        BlockRewriter blockRewriter = BlockRewriter.for1_14((Protocol)this.protocol);
        RecipeRewriter recipeRewriter = new RecipeRewriter(this.protocol);
        ((Protocol1_15_2To1_16)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16.DECLARE_RECIPES, wrapper -> {
            int size;
            int newSize = size = ((Integer)wrapper.passthrough((Type)Type.VAR_INT)).intValue();
            for (int i = 0; i < size; ++i) {
                String originalType = (String)wrapper.read(Type.STRING);
                String type = Key.stripMinecraftNamespace((String)originalType);
                if (type.equals("smithing")) {
                    --newSize;
                    wrapper.read(Type.STRING);
                    wrapper.read(Type.ITEM1_13_2_ARRAY);
                    wrapper.read(Type.ITEM1_13_2_ARRAY);
                    wrapper.read(Type.ITEM1_13_2);
                    continue;
                }
                wrapper.write(Type.STRING, (Object)originalType);
                wrapper.passthrough(Type.STRING);
                recipeRewriter.handleRecipeType(wrapper, type);
            }
            wrapper.set((Type)Type.VAR_INT, 0, (Object)newSize);
        });
        this.registerSetCooldown((ClientboundPacketType)ClientboundPackets1_16.COOLDOWN);
        this.registerWindowItems((ClientboundPacketType)ClientboundPackets1_16.WINDOW_ITEMS, Type.ITEM1_13_2_SHORT_ARRAY);
        this.registerSetSlot((ClientboundPacketType)ClientboundPackets1_16.SET_SLOT, Type.ITEM1_13_2);
        this.registerTradeList((ClientboundPacketType)ClientboundPackets1_16.TRADE_LIST);
        this.registerAdvancements(ClientboundPackets1_16.ADVANCEMENTS, (Type<Item>)Type.ITEM1_13_2);
        blockRewriter.registerAcknowledgePlayerDigging((ClientboundPacketType)ClientboundPackets1_16.ACKNOWLEDGE_PLAYER_DIGGING);
        blockRewriter.registerBlockAction((ClientboundPacketType)ClientboundPackets1_16.BLOCK_ACTION);
        blockRewriter.registerBlockChange((ClientboundPacketType)ClientboundPackets1_16.BLOCK_CHANGE);
        blockRewriter.registerMultiBlockChange((ClientboundPacketType)ClientboundPackets1_16.MULTI_BLOCK_CHANGE);
        ((Protocol1_15_2To1_16)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16.ENTITY_EQUIPMENT, wrapper -> {
            byte slot;
            int entityId = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
            ArrayList<EquipmentData> equipmentData = new ArrayList<EquipmentData>();
            do {
                slot = (Byte)wrapper.read((Type)Type.BYTE);
                Item item = this.handleItemToClient((Item)wrapper.read(Type.ITEM1_13_2));
                int rawSlot = slot & 0x7F;
                equipmentData.add(new EquipmentData(rawSlot, item));
            } while ((slot & 0xFFFFFF80) != 0);
            EquipmentData firstData = (EquipmentData)equipmentData.get(0);
            wrapper.write((Type)Type.VAR_INT, (Object)firstData.slot);
            wrapper.write(Type.ITEM1_13_2, (Object)firstData.item);
            for (int i = 1; i < equipmentData.size(); ++i) {
                PacketWrapper equipmentPacket = wrapper.create((PacketType)ClientboundPackets1_15.ENTITY_EQUIPMENT);
                EquipmentData data = (EquipmentData)equipmentData.get(i);
                equipmentPacket.write((Type)Type.VAR_INT, (Object)entityId);
                equipmentPacket.write((Type)Type.VAR_INT, (Object)data.slot);
                equipmentPacket.write(Type.ITEM1_13_2, (Object)data.item);
                equipmentPacket.send(Protocol1_15_2To1_16.class);
            }
        });
        ((Protocol1_15_2To1_16)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16.UPDATE_LIGHT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.read((Type)Type.BOOLEAN);
            }
        });
        ((Protocol1_15_2To1_16)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16.CHUNK_DATA, wrapper -> {
            Chunk chunk = (Chunk)wrapper.read(ChunkType1_16.TYPE);
            wrapper.write(ChunkType1_15.TYPE, (Object)chunk);
            for (int i2 = 0; i2 < chunk.getSections().length; ++i2) {
                ChunkSection section = chunk.getSections()[i2];
                if (section == null) continue;
                DataPalette palette = section.palette(PaletteType.BLOCKS);
                for (int j = 0; j < palette.size(); ++j) {
                    int mappedBlockStateId = ((Protocol1_15_2To1_16)this.protocol).getMappingData().getNewBlockStateId(palette.idByIndex(j));
                    palette.setIdByIndex(j, mappedBlockStateId);
                }
            }
            CompoundTag heightMaps = chunk.getHeightMap();
            for (Tag heightMapTag : heightMaps.values()) {
                LongArrayTag heightMap = (LongArrayTag)heightMapTag;
                int[] heightMapData = new int[256];
                CompactArrayUtil.iterateCompactArrayWithPadding((int)9, (int)heightMapData.length, (long[])heightMap.getValue(), (i, v) -> {
                    heightMapData[i] = v;
                });
                heightMap.setValue(CompactArrayUtil.createCompactArray((int)9, (int)heightMapData.length, i -> heightMapData[i]));
            }
            if (chunk.isBiomeData()) {
                if (wrapper.user().getProtocolInfo().getServerProtocolVersion() >= ProtocolVersion.v1_16_2.getVersion()) {
                    BiomeStorage biomeStorage = (BiomeStorage)wrapper.user().get(BiomeStorage.class);
                    for (int i3 = 0; i3 < 1024; ++i3) {
                        int biome = chunk.getBiomeData()[i3];
                        int legacyBiome = biomeStorage.legacyBiome(biome);
                        if (legacyBiome == -1) {
                            ViaBackwards.getPlatform().getLogger().warning("Biome sent that does not exist in the biome registry: " + biome);
                            legacyBiome = 1;
                        }
                        chunk.getBiomeData()[i3] = legacyBiome;
                    }
                } else {
                    for (int i4 = 0; i4 < 1024; ++i4) {
                        int biome = chunk.getBiomeData()[i4];
                        switch (biome) {
                            case 170: 
                            case 171: 
                            case 172: 
                            case 173: {
                                chunk.getBiomeData()[i4] = 8;
                            }
                        }
                    }
                }
            }
            if (chunk.getBlockEntities() == null) {
                return;
            }
            for (CompoundTag blockEntity : chunk.getBlockEntities()) {
                this.handleBlockEntity(blockEntity);
            }
        });
        blockRewriter.registerEffect((ClientboundPacketType)ClientboundPackets1_16.EFFECT, 1010, 2001);
        this.registerSpawnParticle((ClientboundPacketType)ClientboundPackets1_16.SPAWN_PARTICLE, Type.ITEM1_13_2, (Type)Type.DOUBLE);
        ((Protocol1_15_2To1_16)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16.WINDOW_PROPERTY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.handler(wrapper -> {
                    short property = (Short)wrapper.get((Type)Type.SHORT, 0);
                    if (property >= 4 && property <= 6) {
                        short enchantmentId = (Short)wrapper.get((Type)Type.SHORT, 1);
                        if (enchantmentId > 11) {
                            enchantmentId = (short)(enchantmentId - 1);
                            wrapper.set((Type)Type.SHORT, 1, (Object)enchantmentId);
                        } else if (enchantmentId == 11) {
                            wrapper.set((Type)Type.SHORT, 1, (Object)9);
                        }
                    }
                });
            }
        });
        ((Protocol1_15_2To1_16)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16.MAP_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BOOLEAN);
                this.map((Type)Type.BOOLEAN);
                this.handler(MapColorRewriter.getRewriteHandler(MapColorRewrites::getMappedColor));
            }
        });
        ((Protocol1_15_2To1_16)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_16.BLOCK_ENTITY_DATA, wrapper -> {
            wrapper.passthrough(Type.POSITION1_14);
            wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
            CompoundTag tag = (CompoundTag)wrapper.passthrough(Type.NAMED_COMPOUND_TAG);
            this.handleBlockEntity(tag);
        });
        this.registerClickWindow((ServerboundPacketType)ServerboundPackets1_14.CLICK_WINDOW, Type.ITEM1_13_2);
        this.registerCreativeInvAction((ServerboundPacketType)ServerboundPackets1_14.CREATIVE_INVENTORY_ACTION, Type.ITEM1_13_2);
        ((Protocol1_15_2To1_16)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_14.EDIT_BOOK, wrapper -> this.handleItemToServer((Item)wrapper.passthrough(Type.ITEM1_13_2)));
    }

    private void handleBlockEntity(CompoundTag tag) {
        StringTag idTag = (StringTag)tag.get("id");
        if (idTag == null) {
            return;
        }
        String id = idTag.getValue();
        if (id.equals("minecraft:conduit")) {
            Tag targetUuidTag = tag.remove("Target");
            if (!(targetUuidTag instanceof IntArrayTag)) {
                return;
            }
            UUID targetUuid = UUIDIntArrayType.uuidFromIntArray((int[])((int[])targetUuidTag.getValue()));
            tag.put("target_uuid", (Tag)new StringTag(targetUuid.toString()));
        } else if (id.equals("minecraft:skull")) {
            Tag skullOwnerTag = tag.remove("SkullOwner");
            if (!(skullOwnerTag instanceof CompoundTag)) {
                return;
            }
            CompoundTag skullOwnerCompoundTag = (CompoundTag)skullOwnerTag;
            Tag ownerUuidTag = skullOwnerCompoundTag.remove("Id");
            if (ownerUuidTag instanceof IntArrayTag) {
                UUID ownerUuid = UUIDIntArrayType.uuidFromIntArray((int[])((int[])ownerUuidTag.getValue()));
                skullOwnerCompoundTag.put("Id", (Tag)new StringTag(ownerUuid.toString()));
            }
            CompoundTag ownerTag = new CompoundTag();
            for (Map.Entry entry : skullOwnerCompoundTag) {
                ownerTag.put((String)entry.getKey(), (Tag)entry.getValue());
            }
            tag.put("Owner", (Tag)ownerTag);
        }
    }

    protected void registerRewrites() {
        this.enchantmentRewriter = new EnchantmentRewriter(this);
        this.enchantmentRewriter.registerEnchantment("minecraft:soul_speed", "\u00a77Soul Speed");
    }

    @Override
    public Item handleItemToClient(Item item) {
        Tag pagesTag;
        CompoundTag ownerCompundTag;
        Tag idTag;
        Tag ownerTag;
        if (item == null) {
            return null;
        }
        super.handleItemToClient(item);
        CompoundTag tag = item.tag();
        if (item.identifier() == 771 && tag != null && (ownerTag = tag.get("SkullOwner")) instanceof CompoundTag && (idTag = (ownerCompundTag = (CompoundTag)ownerTag).get("Id")) instanceof IntArrayTag) {
            UUID ownerUuid = UUIDIntArrayType.uuidFromIntArray((int[])((int[])idTag.getValue()));
            ownerCompundTag.put("Id", (Tag)new StringTag(ownerUuid.toString()));
        }
        if ((item.identifier() == 758 || item.identifier() == 759) && tag != null && (pagesTag = tag.get("pages")) instanceof ListTag) {
            for (Tag page : (ListTag)pagesTag) {
                if (!(page instanceof StringTag)) continue;
                StringTag pageTag = (StringTag)page;
                JsonElement jsonElement = ((Protocol1_15_2To1_16)this.protocol).getTranslatableRewriter().processText(pageTag.getValue());
                pageTag.setValue(jsonElement.toString());
            }
        }
        InventoryPackets.newToOldAttributes((Item)item);
        this.enchantmentRewriter.handleToClient(item);
        return item;
    }

    @Override
    public Item handleItemToServer(Item item) {
        CompoundTag ownerCompundTag;
        Tag idTag;
        Tag ownerTag;
        if (item == null) {
            return null;
        }
        int identifier = item.identifier();
        super.handleItemToServer(item);
        CompoundTag tag = item.tag();
        if (identifier == 771 && tag != null && (ownerTag = tag.get("SkullOwner")) instanceof CompoundTag && (idTag = (ownerCompundTag = (CompoundTag)ownerTag).get("Id")) instanceof StringTag) {
            UUID ownerUuid = UUID.fromString((String)idTag.getValue());
            ownerCompundTag.put("Id", (Tag)new IntArrayTag(UUIDIntArrayType.uuidToIntArray((UUID)ownerUuid)));
        }
        InventoryPackets.oldToNewAttributes((Item)item);
        this.enchantmentRewriter.handleToServer(item);
        return item;
    }

    private static final class EquipmentData {
        private final int slot;
        private final Item item;

        private EquipmentData(int slot, Item item) {
            this.slot = slot;
            this.item = item;
        }
    }
}

