/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.packets;

import com.google.common.primitives.Ints;
import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.rewriters.EnchantmentRewriter;
import com.viaversion.viabackwards.api.rewriters.ItemRewriter;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.Protocol1_12_2To1_13;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.block_entity_handlers.FlowerPotHandler;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.providers.BackwardsBlockEntityProvider;
import com.viaversion.viabackwards.protocol.protocol1_12_2to1_13.storage.BackwardsBlockStorage;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_13;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_9_3;
import com.viaversion.viaversion.libs.opennbt.conversion.ConverterRegistry;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ByteTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.IntTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.NumberTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ShortTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_12_1to1_12.ClientboundPackets1_12_1;
import com.viaversion.viaversion.protocols.protocol1_12_1to1_12.ServerboundPackets1_12_1;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ChatRewriter;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ClientboundPackets1_13;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.Protocol1_13To1_12_2;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.data.BlockIdData;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.data.SpawnEggRewriter;
import com.viaversion.viaversion.util.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class BlockItemPackets1_13
extends ItemRewriter<ClientboundPackets1_13, ServerboundPackets1_12_1, Protocol1_12_2To1_13> {
    private final Map<String, String> enchantmentMappings = new HashMap<String, String>();
    private final String extraNbtTag;

    public BlockItemPackets1_13(Protocol1_12_2To1_13 protocol) {
        super(protocol);
        this.extraNbtTag = "VB|" + ((Object)((Object)protocol)).getClass().getSimpleName() + "|2";
    }

    public static boolean isDamageable(int id) {
        return id >= 256 && id <= 259 || id == 261 || id >= 267 && id <= 279 || id >= 283 && id <= 286 || id >= 290 && id <= 294 || id >= 298 && id <= 317 || id == 346 || id == 359 || id == 398 || id == 442 || id == 443;
    }

    protected void registerPackets() {
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.COOLDOWN, wrapper -> {
            int itemId = (Integer)wrapper.read((Type)Type.VAR_INT);
            int oldId = ((Protocol1_12_2To1_13)this.protocol).getMappingData().getItemMappings().getNewId(itemId);
            if (oldId == -1) {
                wrapper.cancel();
                return;
            }
            if (SpawnEggRewriter.getEntityId((int)oldId).isPresent()) {
                wrapper.write((Type)Type.VAR_INT, (Object)6128);
                return;
            }
            wrapper.write((Type)Type.VAR_INT, (Object)(oldId >> 4));
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.BLOCK_ACTION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_8);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int blockId = (Integer)wrapper.get((Type)Type.VAR_INT, 0);
                    if (blockId == 73) {
                        blockId = 25;
                    } else if (blockId == 99) {
                        blockId = 33;
                    } else if (blockId == 92) {
                        blockId = 29;
                    } else if (blockId == 142) {
                        blockId = 54;
                    } else if (blockId == 305) {
                        blockId = 146;
                    } else if (blockId == 249) {
                        blockId = 130;
                    } else if (blockId == 257) {
                        blockId = 138;
                    } else if (blockId == 140) {
                        blockId = 52;
                    } else if (blockId == 472) {
                        blockId = 209;
                    } else if (blockId >= 483 && blockId <= 498) {
                        blockId = blockId - 483 + 219;
                    }
                    wrapper.set((Type)Type.VAR_INT, 0, (Object)blockId);
                });
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.BLOCK_ENTITY_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_8);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map(Type.NAMED_COMPOUND_TAG);
                this.handler(wrapper -> {
                    BackwardsBlockEntityProvider provider = (BackwardsBlockEntityProvider)Via.getManager().getProviders().get(BackwardsBlockEntityProvider.class);
                    if ((Short)wrapper.get((Type)Type.UNSIGNED_BYTE, 0) == 5) {
                        wrapper.cancel();
                    }
                    wrapper.set(Type.NAMED_COMPOUND_TAG, 0, (Object)provider.transform(wrapper.user(), (Position)wrapper.get(Type.POSITION1_8, 0), (CompoundTag)wrapper.get(Type.NAMED_COMPOUND_TAG, 0)));
                });
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.UNLOAD_CHUNK, wrapper -> {
            int chunkMinX = (Integer)wrapper.passthrough((Type)Type.INT) << 4;
            int chunkMinZ = (Integer)wrapper.passthrough((Type)Type.INT) << 4;
            int chunkMaxX = chunkMinX + 15;
            int chunkMaxZ = chunkMinZ + 15;
            BackwardsBlockStorage blockStorage = (BackwardsBlockStorage)wrapper.user().get(BackwardsBlockStorage.class);
            blockStorage.getBlocks().entrySet().removeIf(entry -> {
                Position position = (Position)entry.getKey();
                return position.x() >= chunkMinX && position.z() >= chunkMinZ && position.x() <= chunkMaxX && position.z() <= chunkMaxZ;
            });
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.BLOCK_CHANGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_8);
                this.handler(wrapper -> {
                    int blockState = (Integer)wrapper.read((Type)Type.VAR_INT);
                    Position position = (Position)wrapper.get(Type.POSITION1_8, 0);
                    BackwardsBlockStorage storage = (BackwardsBlockStorage)wrapper.user().get(BackwardsBlockStorage.class);
                    storage.checkAndStore(position, blockState);
                    wrapper.write((Type)Type.VAR_INT, (Object)((Protocol1_12_2To1_13)BlockItemPackets1_13.this.protocol).getMappingData().getNewBlockStateId(blockState));
                    BlockItemPackets1_13.flowerPotSpecialTreatment(wrapper.user(), blockState, position);
                });
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.MULTI_BLOCK_CHANGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.map((Type)Type.INT);
                this.map(Type.BLOCK_CHANGE_RECORD_ARRAY);
                this.handler(wrapper -> {
                    BackwardsBlockStorage storage = (BackwardsBlockStorage)wrapper.user().get(BackwardsBlockStorage.class);
                    for (BlockChangeRecord record : (BlockChangeRecord[])wrapper.get(Type.BLOCK_CHANGE_RECORD_ARRAY, 0)) {
                        int chunkX = (Integer)wrapper.get((Type)Type.INT, 0);
                        int chunkZ = (Integer)wrapper.get((Type)Type.INT, 1);
                        int block = record.getBlockId();
                        Position position = new Position(record.getSectionX() + chunkX * 16, record.getY(), record.getSectionZ() + chunkZ * 16);
                        storage.checkAndStore(position, block);
                        BlockItemPackets1_13.flowerPotSpecialTreatment(wrapper.user(), block, position);
                        record.setBlockId(((Protocol1_12_2To1_13)BlockItemPackets1_13.this.protocol).getMappingData().getNewBlockStateId(block));
                    }
                });
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.WINDOW_ITEMS, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map(Type.ITEM1_13_ARRAY, Type.ITEM1_8_SHORT_ARRAY);
                this.handler(BlockItemPackets1_13.this.itemArrayToClientHandler(Type.ITEM1_8_SHORT_ARRAY));
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.SET_SLOT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.SHORT);
                this.map(Type.ITEM1_13, Type.ITEM1_8);
                this.handler(BlockItemPackets1_13.this.itemToClientHandler(Type.ITEM1_8));
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.CHUNK_DATA, wrapper -> {
            int i;
            ClientWorld clientWorld = (ClientWorld)wrapper.user().get(ClientWorld.class);
            ChunkType1_9_3 type_old = ChunkType1_9_3.forEnvironment((Environment)clientWorld.getEnvironment());
            ChunkType1_13 type = ChunkType1_13.forEnvironment((Environment)clientWorld.getEnvironment());
            Chunk chunk = (Chunk)wrapper.read((Type)type);
            BackwardsBlockEntityProvider provider = (BackwardsBlockEntityProvider)Via.getManager().getProviders().get(BackwardsBlockEntityProvider.class);
            BackwardsBlockStorage storage = (BackwardsBlockStorage)wrapper.user().get(BackwardsBlockStorage.class);
            for (CompoundTag tag : chunk.getBlockEntities()) {
                int sectionIndex;
                String id;
                Tag idTag = tag.get("id");
                if (idTag == null || !provider.isHandled(id = (String)idTag.getValue()) || (sectionIndex = ((NumberTag)tag.get("y")).asInt() >> 4) < 0 || sectionIndex > 15) continue;
                ChunkSection section = chunk.getSections()[sectionIndex];
                int x = ((NumberTag)tag.get("x")).asInt();
                int y = ((NumberTag)tag.get("y")).asInt();
                int z = ((NumberTag)tag.get("z")).asInt();
                Position position = new Position(x, (short)y, z);
                int block = section.palette(PaletteType.BLOCKS).idAt(x & 0xF, y & 0xF, z & 0xF);
                storage.checkAndStore(position, block);
                provider.transform(wrapper.user(), position, tag);
            }
            for (i = 0; i < chunk.getSections().length; ++i) {
                ChunkSection section = chunk.getSections()[i];
                if (section == null) continue;
                DataPalette palette = section.palette(PaletteType.BLOCKS);
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            int block = palette.idAt(x, y, z);
                            if (!FlowerPotHandler.isFlowah(block)) continue;
                            Position pos = new Position(x + (chunk.getX() << 4), (short)(y + (i << 4)), z + (chunk.getZ() << 4));
                            storage.checkAndStore(pos, block);
                            CompoundTag nbt = provider.transform(wrapper.user(), pos, "minecraft:flower_pot");
                            chunk.getBlockEntities().add(nbt);
                        }
                    }
                }
                for (int j = 0; j < palette.size(); ++j) {
                    int mappedBlockStateId = ((Protocol1_12_2To1_13)this.protocol).getMappingData().getNewBlockStateId(palette.idByIndex(j));
                    palette.setIdByIndex(j, mappedBlockStateId);
                }
            }
            if (chunk.isBiomeData()) {
                for (i = 0; i < 256; ++i) {
                    int biome = chunk.getBiomeData()[i];
                    int newId = -1;
                    switch (biome) {
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: {
                            newId = 9;
                            break;
                        }
                        case 47: 
                        case 48: 
                        case 49: {
                            newId = 24;
                            break;
                        }
                        case 50: {
                            newId = 10;
                            break;
                        }
                        case 44: 
                        case 45: 
                        case 46: {
                            newId = 0;
                        }
                    }
                    if (newId == -1) continue;
                    chunk.getBiomeData()[i] = newId;
                }
            }
            wrapper.write((Type)type_old, (Object)chunk);
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.EFFECT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.map(Type.POSITION1_8);
                this.map((Type)Type.INT);
                this.handler(wrapper -> {
                    int id = (Integer)wrapper.get((Type)Type.INT, 0);
                    int data = (Integer)wrapper.get((Type)Type.INT, 1);
                    if (id == 1010) {
                        wrapper.set((Type)Type.INT, 1, (Object)(((Protocol1_12_2To1_13)BlockItemPackets1_13.this.protocol).getMappingData().getItemMappings().getNewId(data) >> 4));
                    } else if (id == 2001) {
                        data = ((Protocol1_12_2To1_13)BlockItemPackets1_13.this.protocol).getMappingData().getNewBlockStateId(data);
                        int blockId = data >> 4;
                        int blockData = data & 0xF;
                        wrapper.set((Type)Type.INT, 1, (Object)(blockId & 0xFFF | blockData << 12));
                    }
                });
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.MAP_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BOOLEAN);
                this.handler(wrapper -> {
                    int iconCount = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
                    for (int i = 0; i < iconCount; ++i) {
                        int type = (Integer)wrapper.read((Type)Type.VAR_INT);
                        byte x = (Byte)wrapper.read((Type)Type.BYTE);
                        byte z = (Byte)wrapper.read((Type)Type.BYTE);
                        byte direction = (Byte)wrapper.read((Type)Type.BYTE);
                        wrapper.read(Type.OPTIONAL_COMPONENT);
                        if (type > 9) {
                            wrapper.set((Type)Type.VAR_INT, 1, (Object)((Integer)wrapper.get((Type)Type.VAR_INT, 1) - 1));
                            continue;
                        }
                        wrapper.write((Type)Type.BYTE, (Object)((byte)(type << 4 | direction & 0xF)));
                        wrapper.write((Type)Type.BYTE, (Object)x);
                        wrapper.write((Type)Type.BYTE, (Object)z);
                    }
                });
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.ENTITY_EQUIPMENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.map(Type.ITEM1_13, Type.ITEM1_8);
                this.handler(BlockItemPackets1_13.this.itemToClientHandler(Type.ITEM1_8));
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_13.WINDOW_PROPERTY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.handler(wrapper -> {
                    short property = (Short)wrapper.get((Type)Type.SHORT, 0);
                    if (property >= 4 && property <= 6) {
                        short oldId = (Short)wrapper.get((Type)Type.SHORT, 1);
                        wrapper.set((Type)Type.SHORT, 1, (Object)((short)((Protocol1_12_2To1_13)BlockItemPackets1_13.this.protocol).getMappingData().getEnchantmentMappings().getNewId((int)oldId)));
                    }
                });
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_12_1.CREATIVE_INVENTORY_ACTION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.SHORT);
                this.map(Type.ITEM1_8, Type.ITEM1_13);
                this.handler(BlockItemPackets1_13.this.itemToServerHandler(Type.ITEM1_13));
            }
        });
        ((Protocol1_12_2To1_13)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_12_1.CLICK_WINDOW, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.VAR_INT);
                this.map(Type.ITEM1_8, Type.ITEM1_13);
                this.handler(BlockItemPackets1_13.this.itemToServerHandler(Type.ITEM1_13));
            }
        });
    }

    protected void registerRewrites() {
        this.enchantmentMappings.put("minecraft:loyalty", "\u00a77Loyalty");
        this.enchantmentMappings.put("minecraft:impaling", "\u00a77Impaling");
        this.enchantmentMappings.put("minecraft:riptide", "\u00a77Riptide");
        this.enchantmentMappings.put("minecraft:channeling", "\u00a77Channeling");
    }

    @Override
    public Item handleItemToClient(Item item) {
        Tag originalIdTag;
        if (item == null) {
            return null;
        }
        int originalId = item.identifier();
        Integer rawId = null;
        boolean gotRawIdFromTag = false;
        CompoundTag tag = item.tag();
        if (tag != null && (originalIdTag = tag.remove(this.extraNbtTag)) != null) {
            rawId = ((NumberTag)originalIdTag).asInt();
            gotRawIdFromTag = true;
        }
        if (rawId == null) {
            super.handleItemToClient(item);
            if (item.identifier() == -1) {
                if (originalId == 362) {
                    rawId = 0xE50000;
                } else {
                    if (!Via.getConfig().isSuppressConversionWarnings() || Via.getManager().isDebug()) {
                        ViaBackwards.getPlatform().getLogger().warning("Failed to get 1.12 item for " + originalId);
                    }
                    rawId = 65536;
                }
            } else {
                if (tag == null) {
                    tag = item.tag();
                }
                rawId = this.itemIdToRaw(item.identifier(), item, tag);
            }
        }
        item.setIdentifier(rawId >> 16);
        item.setData((short)(rawId & 0xFFFF));
        if (tag != null) {
            StringTag name;
            if (BlockItemPackets1_13.isDamageable(item.identifier())) {
                Tag damageTag = tag.remove("Damage");
                if (!gotRawIdFromTag && damageTag instanceof IntTag) {
                    item.setData((short)((Integer)damageTag.getValue()).intValue());
                }
            }
            if (item.identifier() == 358) {
                Tag mapTag = tag.remove("map");
                if (!gotRawIdFromTag && mapTag instanceof IntTag) {
                    item.setData((short)((Integer)mapTag.getValue()).intValue());
                }
            }
            this.invertShieldAndBannerId(item, tag);
            CompoundTag display = (CompoundTag)tag.get("display");
            if (display != null && (name = (StringTag)display.get("Name")) != null) {
                display.put(this.extraNbtTag + "|Name", (Tag)new StringTag(name.getValue()));
                name.setValue(((Protocol1_12_2To1_13)this.protocol).jsonToLegacy(name.getValue()));
            }
            this.rewriteEnchantmentsToClient(tag, false);
            this.rewriteEnchantmentsToClient(tag, true);
            this.rewriteCanPlaceToClient(tag, "CanPlaceOn");
            this.rewriteCanPlaceToClient(tag, "CanDestroy");
        }
        return item;
    }

    private int itemIdToRaw(int oldId, Item item, CompoundTag tag) {
        Optional eggEntityId = SpawnEggRewriter.getEntityId((int)oldId);
        if (eggEntityId.isPresent()) {
            if (tag == null) {
                tag = new CompoundTag();
                item.setTag(tag);
            }
            if (!tag.contains("EntityTag")) {
                CompoundTag entityTag = new CompoundTag();
                entityTag.put("id", (Tag)new StringTag((String)eggEntityId.get()));
                tag.put("EntityTag", (Tag)entityTag);
            }
            return 25100288;
        }
        return oldId >> 4 << 16 | oldId & 0xF;
    }

    private void rewriteCanPlaceToClient(CompoundTag tag, String tagName) {
        if (!(tag.get(tagName) instanceof ListTag)) {
            return;
        }
        ListTag blockTag = (ListTag)tag.get(tagName);
        if (blockTag == null) {
            return;
        }
        ListTag newCanPlaceOn = new ListTag(StringTag.class);
        tag.put(this.extraNbtTag + "|" + tagName, ConverterRegistry.convertToTag((Object)ConverterRegistry.convertToValue((Tag)blockTag)));
        for (Tag oldTag : blockTag) {
            String[] newValues;
            Object value = oldTag.getValue();
            String[] stringArray = newValues = value instanceof String ? (String[])BlockIdData.fallbackReverseMapping.get(Key.stripMinecraftNamespace((String)((String)value))) : null;
            if (newValues != null) {
                for (String newValue : newValues) {
                    newCanPlaceOn.add((Tag)new StringTag(newValue));
                }
                continue;
            }
            newCanPlaceOn.add(oldTag);
        }
        tag.put(tagName, (Tag)newCanPlaceOn);
    }

    private void rewriteEnchantmentsToClient(CompoundTag tag, boolean storedEnch) {
        String key = storedEnch ? "StoredEnchantments" : "Enchantments";
        ListTag enchantments = (ListTag)tag.get(key);
        if (enchantments == null) {
            return;
        }
        ListTag noMapped = new ListTag(CompoundTag.class);
        ListTag newEnchantments = new ListTag(CompoundTag.class);
        ArrayList<StringTag> lore = new ArrayList<StringTag>();
        boolean hasValidEnchants = false;
        for (Tag enchantmentEntryTag : enchantments.clone()) {
            CompoundTag enchantmentEntry = (CompoundTag)enchantmentEntryTag;
            Tag idTag = enchantmentEntry.get("id");
            if (!(idTag instanceof StringTag)) continue;
            String newId = (String)idTag.getValue();
            NumberTag levelTag = (NumberTag)enchantmentEntry.get("lvl");
            if (levelTag == null) continue;
            int levelValue = levelTag.asInt();
            int level = levelValue < Short.MAX_VALUE ? (int)levelValue : Short.MAX_VALUE;
            String mappedEnchantmentId = this.enchantmentMappings.get(newId);
            if (mappedEnchantmentId != null) {
                lore.add(new StringTag(mappedEnchantmentId + " " + EnchantmentRewriter.getRomanNumber(level)));
                noMapped.add((Tag)enchantmentEntry);
                continue;
            }
            if (newId.isEmpty()) continue;
            Short oldId = (Short)Protocol1_13To1_12_2.MAPPINGS.getOldEnchantmentsIds().inverse().get((Object)Key.stripMinecraftNamespace((String)newId));
            if (oldId == null) {
                if (!newId.startsWith("viaversion:legacy/")) {
                    noMapped.add((Tag)enchantmentEntry);
                    if (ViaBackwards.getConfig().addCustomEnchantsToLore()) {
                        String name = newId;
                        int index = name.indexOf(58) + 1;
                        if (index != 0 && index != name.length()) {
                            name = name.substring(index);
                        }
                        name = "\u00a77" + Character.toUpperCase(name.charAt(0)) + name.substring(1).toLowerCase(Locale.ENGLISH);
                        lore.add(new StringTag(name + " " + EnchantmentRewriter.getRomanNumber(level)));
                    }
                    if (!Via.getManager().isDebug()) continue;
                    ViaBackwards.getPlatform().getLogger().warning("Found unknown enchant: " + newId);
                    continue;
                }
                oldId = Short.valueOf(newId.substring(18));
            }
            if (level != 0) {
                hasValidEnchants = true;
            }
            CompoundTag newEntry = new CompoundTag();
            newEntry.put("id", (Tag)new ShortTag(oldId.shortValue()));
            newEntry.put("lvl", (Tag)new ShortTag((short)level));
            newEnchantments.add((Tag)newEntry);
        }
        if (!storedEnch && !hasValidEnchants) {
            IntTag hideFlags = (IntTag)tag.get("HideFlags");
            if (hideFlags == null) {
                hideFlags = new IntTag();
                tag.put(this.extraNbtTag + "|DummyEnchant", (Tag)new ByteTag());
            } else {
                tag.put(this.extraNbtTag + "|OldHideFlags", (Tag)new IntTag((int)hideFlags.asByte()));
            }
            if (newEnchantments.size() == 0) {
                CompoundTag enchEntry = new CompoundTag();
                enchEntry.put("id", (Tag)new ShortTag(0));
                enchEntry.put("lvl", (Tag)new ShortTag(0));
                newEnchantments.add((Tag)enchEntry);
            }
            int value = hideFlags.asByte() | 1;
            hideFlags.setValue(value);
            tag.put("HideFlags", (Tag)hideFlags);
        }
        if (noMapped.size() != 0) {
            tag.put(this.extraNbtTag + "|" + key, (Tag)noMapped);
            if (!lore.isEmpty()) {
                ListTag loreTag;
                CompoundTag display = (CompoundTag)tag.get("display");
                if (display == null) {
                    display = new CompoundTag();
                    tag.put("display", (Tag)display);
                }
                if ((loreTag = (ListTag)display.get("Lore")) == null) {
                    loreTag = new ListTag(StringTag.class);
                    display.put("Lore", (Tag)loreTag);
                    tag.put(this.extraNbtTag + "|DummyLore", (Tag)new ByteTag());
                } else if (loreTag.size() != 0) {
                    ListTag oldLore = new ListTag(StringTag.class);
                    for (Tag value : loreTag) {
                        oldLore.add(value.clone());
                    }
                    tag.put(this.extraNbtTag + "|OldLore", (Tag)oldLore);
                    lore.addAll(loreTag.getValue());
                }
                loreTag.setValue(lore);
            }
        }
        tag.remove("Enchantments");
        tag.put(storedEnch ? key : "ench", (Tag)newEnchantments);
    }

    @Override
    public Item handleItemToServer(Item item) {
        if (item == null) {
            return null;
        }
        CompoundTag tag = item.tag();
        int originalId = item.identifier() << 16 | item.data() & 0xFFFF;
        int rawId = item.identifier() << 4 | item.data() & 0xF;
        if (BlockItemPackets1_13.isDamageable(item.identifier())) {
            if (tag == null) {
                tag = new CompoundTag();
                item.setTag(tag);
            }
            tag.put("Damage", (Tag)new IntTag((int)item.data()));
        }
        if (item.identifier() == 358) {
            if (tag == null) {
                tag = new CompoundTag();
                item.setTag(tag);
            }
            tag.put("map", (Tag)new IntTag((int)item.data()));
        }
        if (tag != null) {
            CompoundTag displayTag;
            StringTag name;
            this.invertShieldAndBannerId(item, tag);
            Tag display = tag.get("display");
            if (display instanceof CompoundTag && (name = (StringTag)(displayTag = (CompoundTag)display).get("Name")) != null) {
                StringTag via = (StringTag)displayTag.remove(this.extraNbtTag + "|Name");
                name.setValue(via != null ? via.getValue() : ChatRewriter.legacyTextToJsonString((String)name.getValue()));
            }
            this.rewriteEnchantmentsToServer(tag, false);
            this.rewriteEnchantmentsToServer(tag, true);
            this.rewriteCanPlaceToServer(tag, "CanPlaceOn");
            this.rewriteCanPlaceToServer(tag, "CanDestroy");
            if (item.identifier() == 383) {
                StringTag identifier;
                CompoundTag entityTag = (CompoundTag)tag.get("EntityTag");
                if (entityTag != null && (identifier = (StringTag)entityTag.get("id")) != null) {
                    rawId = SpawnEggRewriter.getSpawnEggId((String)identifier.getValue());
                    if (rawId == -1) {
                        rawId = 25100288;
                    } else {
                        entityTag.remove("id");
                        if (entityTag.isEmpty()) {
                            tag.remove("EntityTag");
                        }
                    }
                } else {
                    rawId = 25100288;
                }
            }
            if (tag.isEmpty()) {
                tag = null;
                item.setTag(null);
            }
        }
        int identifier = item.identifier();
        item.setIdentifier(rawId);
        super.handleItemToServer(item);
        if (item.identifier() != rawId && item.identifier() != -1) {
            return item;
        }
        item.setIdentifier(identifier);
        int newId = -1;
        if (((Protocol1_12_2To1_13)this.protocol).getMappingData().getItemMappings().inverse().getNewId(rawId) == -1) {
            if (!BlockItemPackets1_13.isDamageable(item.identifier()) && item.identifier() != 358) {
                if (tag == null) {
                    tag = new CompoundTag();
                    item.setTag(tag);
                }
                tag.put(this.extraNbtTag, (Tag)new IntTag(originalId));
            }
            if (item.identifier() == 229) {
                newId = 362;
            } else if (item.identifier() == 31 && item.data() == 0) {
                rawId = 512;
            } else if (((Protocol1_12_2To1_13)this.protocol).getMappingData().getItemMappings().inverse().getNewId(rawId & 0xFFFFFFF0) != -1) {
                rawId &= 0xFFFFFFF0;
            } else {
                if (!Via.getConfig().isSuppressConversionWarnings() || Via.getManager().isDebug()) {
                    ViaBackwards.getPlatform().getLogger().warning("Failed to get 1.13 item for " + item.identifier());
                }
                rawId = 16;
            }
        }
        if (newId == -1) {
            newId = ((Protocol1_12_2To1_13)this.protocol).getMappingData().getItemMappings().inverse().getNewId(rawId);
        }
        item.setIdentifier(newId);
        item.setData((short)0);
        return item;
    }

    private void rewriteCanPlaceToServer(CompoundTag tag, String tagName) {
        if (!(tag.get(tagName) instanceof ListTag)) {
            return;
        }
        ListTag blockTag = (ListTag)tag.remove(this.extraNbtTag + "|" + tagName);
        if (blockTag != null) {
            tag.put(tagName, ConverterRegistry.convertToTag((Object)ConverterRegistry.convertToValue((Tag)blockTag)));
        } else {
            blockTag = (ListTag)tag.get(tagName);
            if (blockTag != null) {
                ListTag newCanPlaceOn = new ListTag(StringTag.class);
                for (Tag oldTag : blockTag) {
                    String lowerCaseId;
                    String[] newValues;
                    Object value = oldTag.getValue();
                    String oldId = Key.stripMinecraftNamespace((String)value.toString());
                    int key = Ints.tryParse((String)oldId);
                    String numberConverted = (String)BlockIdData.numberIdToString.get(key);
                    if (numberConverted != null) {
                        oldId = numberConverted;
                    }
                    if ((newValues = (String[])BlockIdData.blockIdMapping.get(lowerCaseId = oldId.toLowerCase(Locale.ROOT))) != null) {
                        for (String newValue : newValues) {
                            newCanPlaceOn.add((Tag)new StringTag(newValue));
                        }
                        continue;
                    }
                    newCanPlaceOn.add((Tag)new StringTag(lowerCaseId));
                }
                tag.put(tagName, (Tag)newCanPlaceOn);
            }
        }
    }

    private void rewriteEnchantmentsToServer(CompoundTag tag, boolean storedEnch) {
        ListTag oldLore;
        CompoundTag display;
        String key = storedEnch ? "StoredEnchantments" : "Enchantments";
        ListTag enchantments = (ListTag)tag.get(storedEnch ? key : "ench");
        if (enchantments == null) {
            return;
        }
        ListTag newEnchantments = new ListTag(CompoundTag.class);
        boolean dummyEnchant = false;
        if (!storedEnch) {
            Iterator hideFlags = (IntTag)tag.remove(this.extraNbtTag + "|OldHideFlags");
            if (hideFlags != null) {
                tag.put("HideFlags", (Tag)new IntTag((int)hideFlags.asByte()));
                dummyEnchant = true;
            } else if (tag.remove(this.extraNbtTag + "|DummyEnchant") != null) {
                tag.remove("HideFlags");
                dummyEnchant = true;
            }
        }
        for (Object enchEntry : enchantments) {
            CompoundTag enchantmentEntry = new CompoundTag();
            short oldId = ((NumberTag)((CompoundTag)enchEntry).get("id")).asShort();
            short level = ((NumberTag)((CompoundTag)enchEntry).get("lvl")).asShort();
            if (dummyEnchant && oldId == 0 && level == 0) continue;
            String newId = (String)Protocol1_13To1_12_2.MAPPINGS.getOldEnchantmentsIds().get((Object)oldId);
            if (newId == null) {
                newId = "viaversion:legacy/" + oldId;
            }
            enchantmentEntry.put("id", (Tag)new StringTag(newId));
            enchantmentEntry.put("lvl", (Tag)new ShortTag(level));
            newEnchantments.add((Tag)enchantmentEntry);
        }
        ListTag noMapped = (ListTag)tag.remove(this.extraNbtTag + "|Enchantments");
        if (noMapped != null) {
            for (Tag value : noMapped) {
                newEnchantments.add(value);
            }
        }
        if ((display = (CompoundTag)tag.get("display")) == null) {
            display = new CompoundTag();
            tag.put("display", (Tag)display);
        }
        if ((oldLore = (ListTag)tag.remove(this.extraNbtTag + "|OldLore")) != null) {
            ListTag lore = (ListTag)display.get("Lore");
            if (lore == null) {
                lore = new ListTag();
                tag.put("Lore", (Tag)lore);
            }
            lore.setValue(oldLore.getValue());
        } else if (tag.remove(this.extraNbtTag + "|DummyLore") != null) {
            display.remove("Lore");
            if (display.isEmpty()) {
                tag.remove("display");
            }
        }
        if (!storedEnch) {
            tag.remove("ench");
        }
        tag.put(key, (Tag)newEnchantments);
    }

    private void invertShieldAndBannerId(Item item, CompoundTag tag) {
        Tag patterns;
        if (item.identifier() != 442 && item.identifier() != 425) {
            return;
        }
        Tag blockEntityTag = tag.get("BlockEntityTag");
        if (!(blockEntityTag instanceof CompoundTag)) {
            return;
        }
        CompoundTag blockEntityCompoundTag = (CompoundTag)blockEntityTag;
        Tag base = blockEntityCompoundTag.get("Base");
        if (base instanceof IntTag) {
            IntTag baseTag = (IntTag)base;
            baseTag.setValue(15 - baseTag.asInt());
        }
        if ((patterns = blockEntityCompoundTag.get("Patterns")) instanceof ListTag) {
            ListTag patternsTag = (ListTag)patterns;
            for (Tag pattern : patternsTag) {
                if (!(pattern instanceof CompoundTag)) continue;
                IntTag colorTag = (IntTag)((CompoundTag)pattern).get("Color");
                colorTag.setValue(15 - colorTag.asInt());
            }
        }
    }

    private static void flowerPotSpecialTreatment(UserConnection user, int blockState, Position position) throws Exception {
        if (FlowerPotHandler.isFlowah(blockState)) {
            BackwardsBlockEntityProvider beProvider = (BackwardsBlockEntityProvider)Via.getManager().getProviders().get(BackwardsBlockEntityProvider.class);
            CompoundTag nbt = beProvider.transform(user, position, "minecraft:flower_pot");
            PacketWrapper blockUpdateRemove = PacketWrapper.create((PacketType)ClientboundPackets1_12_1.BLOCK_CHANGE, (UserConnection)user);
            blockUpdateRemove.write(Type.POSITION1_8, (Object)position);
            blockUpdateRemove.write((Type)Type.VAR_INT, (Object)0);
            blockUpdateRemove.scheduleSend(Protocol1_12_2To1_13.class);
            PacketWrapper blockCreate = PacketWrapper.create((PacketType)ClientboundPackets1_12_1.BLOCK_CHANGE, (UserConnection)user);
            blockCreate.write(Type.POSITION1_8, (Object)position);
            blockCreate.write((Type)Type.VAR_INT, (Object)Protocol1_12_2To1_13.MAPPINGS.getNewBlockStateId(blockState));
            blockCreate.scheduleSend(Protocol1_12_2To1_13.class);
            PacketWrapper wrapper = PacketWrapper.create((PacketType)ClientboundPackets1_12_1.BLOCK_ENTITY_DATA, (UserConnection)user);
            wrapper.write(Type.POSITION1_8, (Object)position);
            wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)5);
            wrapper.write(Type.NAMED_COMPOUND_TAG, (Object)nbt);
            wrapper.scheduleSend(Protocol1_12_2To1_13.class);
        }
    }
}

